;------------------------------------------------------------------------------
; JumpinG The Tutorial Game
;  2011 Jose Vila Cuadrillero
;  2011 DIMENSION Z ( Es marca registrada de Jose Vila Cuadrillero )
; Inicio del Desarrollo 20/10/2011
; Final del Desarrollo 25/01/2012
; 
; Pagina WEB - www.dimensionzgames.com
; e-mail - pepe.vila@dimensionzgames.com
;
; ESTE JUEGO Y TODO SU CONTENIDO ES DE CODIGO ABIERTO SOLO PARA PROPOSITOS EDUCATIVOS
; QUEDA TOTALMENTE PROHIBIDA LA VENTA O DISTRIBUCION EN CUALQUIER MEDIO, SIN PERMISO.
;------------------------------------------------------------------------------

;---------------------------------------------------------
; CONTANTES
;---------------------------------------------------------
	NUM_ENE		equ 4		; numero de enemigos en la tabla de enemigos
	POS_SPR		equ 16		; numero de sprite donde situamos los enemigos
	VAL_ENE		equ 14		; numero de valores de la tabla de enemigos
	ANCHO_PROTA	equ 9		; ancho del protagonista
	ALTO_PROTA	equ 16		; alto del protagonista
	SOBRA_X		equ 3		; pixeles que le sobran al prota por delante de la X
	SOBRA_Y		equ 0		; pixeles que le sobran al prota por arriba de la Y
	VAL_OBJ		equ 10		; numero de objetos por cada pantalla
	PANTAS		equ 40		; numero de pantallas del juego

	IDIOMA		equ 1		; 1=Espaol | 0=English
;---------------------------------------------------------
; VARIABLES DEL SISTEMA
;---------------------------------------------------------

;---------------------------------------------------------
; VARIABLES DEL SISTEMA
;---------------------------------------------------------
; Aqu definimos con nombres las direcciones de memoria de la VRAM 
; Direcciones de la VRAM 
	CHRTBL		equ	0000h	; Tabla de caracteres
	NAMTBL		equ	1800h	; Tabla de Nombres
	SPRATR		equ	1B00h	; Tabla de los atributos de los sprites
	CLRTBL		equ	2000h	; Tabla del color de los caracteres
	SPRTBL		equ	3800h	; Tabla de Sprites
; Variables del Sistema MSX
	CLIKSW		equ	$F3DB	; Keyboard click sound
	RG1SAV		equ	$F3E0	; Content of VDP(1) register (R#1)
	STATFL		equ	$F3E7	; Content of VDP(8) status register (S#0)
	FORCLR		equ	$F3E9	; Foreground colour
	NEWKEY		equ	$FBE5	; NEWKEY memory area at #FBE5-#FBEF
	HOOK		equ	$FD9F	; Vector de Interrupcion del MSX

;---------------------------------------------------------
; DIRECTIVAS PARA EL ENSAMBLADOR ( asMSX )
;---------------------------------------------------------
	.bios		; Definir Nombres de las llamadas a la BIOS
	.page 1		; Definir la direccin del cdigo ir en 4000h
	.rom		; Esto es para indicar que crearemos una ROM
	.size 32	; vamos a crear una ROM de 32KB
	.start INI_ROM	; Inicio del Cdigo de nuestro Programa
; Seguir la norma del Standard MSX
	.dw 0,0,0,0,0,0	; 12 ceros
; Indentificacion no es necesaria pero es un tributo a los clasicos
IF (IDIOMA==1)
	.db "DMZ001-JumpinGe",1Ah
ELSE
	.db "DMZ001-JumpinGi",1Ah
ENDIF

;---------------------------------------------------------
; INICIO DEL PROGRAMA
;---------------------------------------------------------
INI_ROM:
				; la bios situa los 16Kb primeros en la pagina 1 pero los 16Kb superiores no lo hace
	.search			; localizar el slot y sub-slot para alojar los 16Kb de la pagina 2 para la ROM
				; esta es una macro intruccion del asMSX que lo automatiza ver tutorial de jltursan
				; en karoshi http://karoshi.auic.es/index.php?topic=628.0 para hacerlo de forma manual
	di
	im	1		; Habilito el modo 1 de interrupciones para la musica
	ld	sp,$F380	; Stack o pila debajo de las variables del sistema
	ei     

; Borrar Buffers y variables en RAM
	ld	hl,INI_RAM		; direccion de inicio
	ld	de,INI_RAM+1		; direccion de inicio mas uno
	ld	bc,FIN_RAM - INI_RAM	; numero de bytes a borrar
	ld	[hl],0			; valor a escribir 0
	ldir				; hazlo

;--------------------------------------
; Iniciar el Player Musical de WYZ
	DI
	CALL	INICIA_PLAYER		; modifica las interrupciones y el activa el player
	EI
;--------------------------------------

	call	INIT_MODE_SCx	; iniciar el modo de pantalla y otros valores

MENU_0:
; Mostrar logo del creador
	call	GFXmenus	; Colocar los graficos logos y letras de los menus
	call	MI_LOGO		; Mostrar el logo de Dimension Z
	
; aqui empieza el bucle de los tres menus del juego
BUCLE_MENUS:
	xor	a		
	ld	[VOLVER],a	; Variable VOLVER a 0 = no vuelve

; menu principal
	call	MENU_GAME	; Rutina que muestra el menu inicial del juego
	ld	a,[VOLVER]	; vamos a mirar si en el menu del juego se pulso espacio
	cp	1		; si es 1 se ha pulsado espacio en el menu
	jr	z,INI_JUEGO	; SI? vamos a jugar al juego

; menu historia
	call	CORTINA_SALE	; cortinilla de borrado de la pantalla de DER. a IZQ.
	call	MENU_HISTORIA	; rutina que muestra el menu de la historia del juego 
	ld	a,[VOLVER]	; vamos a mirar si en el menu historia se pulso espacio
	cp	1		; si es 1 se ha pulsado el espacio en el menu
	jr	z,BUCLE_MENUS	; SI? lo mandamos a mostrar el menu del juego

; menu principal
	call	MENU_GAME	; rutina que muestra el menu inicial del juego
	ld	a,[VOLVER]	; vamos a mirar si en el menu del juego se pulso espacio
	cp	1		; si es 1 se ha pulsado espacio en el menu
	jr	z,INI_JUEGO	; SI? vamos a jugar al juego

; menu de creditos
	call	CORTINA_SALE	; cortinilla de borrado de la pantalla de DER. a IZQ.
	call	MENU_CREDITOS	; rutina que muestra el menu de creditos del juego 
	ld	a,[VOLVER]	; vamos a mirar si en el menu creditos se pulso espacio
	cp	1		; si es 1 se ha pulsado el espacio en el menu
	jr	z,BUCLE_MENUS	; SI? lo mandamos a mostrar el menu del juego

; menu principal
	call	MENU_GAME	; rutina que muestra el menu inicial del juego
	ld	a,[VOLVER]	; vamos a mirar si en el menu del juego se pulso espacio
	cp	1		; si es 1 se ha pulsado el espacio en el menu
	jr	z,INI_JUEGO	; SI? vamos a jugar al juego

	call	CORTINA_SALE	; cortinilla de Borrado de la pantalla de DER. a IZQ.

; mostrar el juego en Modo Demo
MODO_DEMO:
	xor	a		; ld a,0
	ld	[DEMO],a	; ponemos la variable DEMO de que el juego esta en modo demo

	jr	JUEGO		; lo mandamos como si fueramos a jugar


INI_JUEGO:	
; EMPIEZA EL JUEGO PORQUE HEMOS PULSADO EL BOTON PULSA PARA EMPEZAR

;--------------------------------------
; Musica del PULSA PARA EMPEZAR
; WYZ
	CALL	PLAYER_OFF	; paramos la cancion si esta sonando algo
; descomprimir la musica del pulsa para empezar y dejarla en RAM
	ld	hl,SONG_0	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la cancion del pulsa para empezar
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
; WYZ
;--------------------------------------

	ld	b,16		; veces que se repite

; aqui hacemos que el PULSA PARA EMPEZAR parpadea rapido
@@BUCLE_FLASH:
	push	bc
	halt
	halt			; unas cuantas pausas
	halt
	call	@@PONE_TXT	; pone texto PULSA PARA EMPEZAR
	halt
	halt			; unas cuantas pausas
	halt
	call	@@BORRA_TXT	; borra texto PULSA PARA EMPEZAR
	pop	bc
	djnz	@@BUCLE_FLASH	; repetimos todo 16 veces

	call	CORTINA_SALE	; cortinilla de Borrado de la pantalla de DER. a IZQ.

; como hemos pulsado EL PULSA PARA EMPEZAR el juego no estara en Modo DEMO 
	ld	a,1		; vamos a poner la variable DEMO a 1 = No en demo
	ld	[DEMO],a	; y la almacenamos

; Aqui es donde preparamos el comienzo del JUEGO
JUEGO:

; colocar los Graficos del juego en VRAM, como los CHRs,CLRs,SPRs etc.
	call	GFXgame

; Mostrar en pantalla marcadores y el texto PREPARADO: y cortinilla de pantalla
	call	PREPARADO

; Inicializar las varibles del juego
	call	VAR_JUEGO

; inicializar Mapeado del juego mostrar la primera pantalla
	call	PANTALLAS

; vamos a mirar si estamos en Modo DEMO, para hacer que no suene la musica del juego
	ld	a,[DEMO]		; leemos la variable DEMO
	or	a			; es 0?
	jr	z,BuclePrincipal	; SI? estamos en modo demo y vamos al BuclePrincipal
;---------------------------------------------------------
; WYZ
	call	PLAYER_OFF	; detenemos la reproduccion de la musica
; descomprimir la musica principal del juego y dejarla en RAM
	ld	hl,SONG_1	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la musica del juego
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
; WYZ
;---------------------------------------------------------

;---------------------------------------------------------
; BUCLE PRINCIPAL DEL JUEGO
; AQUI TRASNCURRE TODA LA ACCION DEL JUEGO
;---------------------------------------------------------
BuclePrincipal:	

	call	MOVER_PROTA		; Gestiona el movimiento del prota y las colisiones con fondo

	call	MOVER_ENEMIGOS		; Gestiona el movimiento de los enemigos
	
	call	COLISIONAN_SPRs		; Gestiona las colisiones del prota con los enemigos

	call	MARCADOR		; Actualiza puntos y muestra el marcador del juego en la pantalla

	call	ANIMA_OBJETOS		; se encarga de animar los objetos del juego

;	call	FLICKERING		; se encarga de cambiar el orden en la tabla de ATRs de los SPRs

	halt				; espera al VBLANK

; mover los ATRs de todos los Sprites de RAM a la SPRTBL en VRAM
	ld	hl,bufATRsSPRs		; ATRs de los SPRs en RAM
	ld	de,SPRATR		; destino Sprite Attribute Pattern
;	ld	bc,11*4			; 8 fantasmas+3 del prota ; en la rutina de flickering quito los ATRs de los enemigos
	ld	bc,15*4			; 8 fantasmas+3 del prota+4 enemigos * 4 ATRs
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

; esto vuelca los ATRs de los SPRs enemigos de la rutina de FLICKERING
; mover los ATRs de todos los Sprites de RAM a la SPRTBL en VRAM
;	ld	hl,[PUNTERO_FLICKER]	; ATRs de los SPRs en RAM
;	ld	de,SPRATR+(11*4)	; destino Sprite Attribute Pattern
;	ld	bc,NUM_ENE*5		; 8 fantasmas+2 del prota+4 enemigos*4 ATRs
;	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

; vamos a mirar si estamos en modo demo.
	ld	a,[DEMO]		; leemos la variable
	or	a			; es 0?
	jr	z,BuclePrincipal	; SI? no leemos mas teclas y lo mandamo al BuclePrincipal

; vamos a mirar si hemos pulsado el espacio en el teclado para usar un paralizador
	xor	a			; seleccionamos el teclado
	call	GTTRIG			; 0D8h - BIOS - Get trigger status
	or	a			; Se ha pulsado SPACIO en el teclado?			
	call	nz,FUEGO		; NO? vamos a fuego

; vamos a mirar si hemos pulsado el boton 1 del joystick para usar un paralizador
	ld	a,1			; seleccionamos el joystick 1
	call	GTTRIG			; 0D8h - BIOS - Get trigger status
	or	a			; Se ha pulsado el boton 1 del Joystick?			
	call	nz,FUEGO		; NO? vamos a fuego

; vamos a mirar si hemos pulsado la tecla "P" para PAUSAR el juego
	ld	a,[NEWKEY+4]		; leemos la ROW 4 del teclado
	bit	5,a			; leemos el bit 5 de la ROW 4 tecla "P"
	jr	z,@@PAUSAR		; SI? vamos a pausar el juego

; vamos a mirar si hemos pulsado la tecla "F1" para mostrar el menu de objetos
	ld	a,[NEWKEY+6]		; leemos la ROW 6 del teclado
	bit	5,a			; leemos el bit 5 de la ROW 6 tecla "F1"
	jr	z,@@MENU_OBJETOS	; SI? vamos a mostrar el menu de objetos

; vamos a mirar si hemos pulsado CONTROL+STOP para salir del juego
	call	0B7h			; 0B7h - BIOS - Check CTRL-STOP key directly
	jp	c,INI_ROM		; si hemos pulsado vamos INICIAR EL JUEGO

	xor	a
	ld	[PAUSA],a		; variable PAUSA=0 no pulsada

	jr	BuclePrincipal		; seguimos con el Bucle Principal del juego.

;--------------------------------------

@@PAUSAR:
	ld	a,[PAUSA]		; leemos la variable PAUSA
	cp	1			; si es 1 es que hemos pulsado la tecla "P"...
	jr	z,BuclePrincipal	; ...y vamos a continuar con el Bucle Principal del juego.
	ld	a,1
	ld	[PAUSA],a		; variable PAUSA=1 pulsada

; mostramos el texto de "PAUSA" en el marcador en la zona de vidas
	ld	hl,TXT_PAUSA		; TEXTO PAUSA
IF (IDIOMA==1)
	ld	de,NAMTBL+(1*32)+14	; linea 2 columna 14
	ld	bc,5			; numero de CHRs
ELSE
	ld	de,NAMTBL+(1*32)+13	; linea 2 columna 13
	ld	bc,6			; numero de CHRs
ENDIF
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory
@@EN_PAUSA:
	ld	a,[NEWKEY+4]		; leemos la ROW 4 del teclado
	bit	5,a			; leemos el bit 5 de la ROW 4 tecla "P"
	jr	z,@@SALIR_PAUSA		; SI? salimos de la pausa
	xor	a			; else
	ld	[PAUSA],a		; variable PAUSA=0 no pulsada
	jr	@@EN_PAUSA		; seguimos en pausa sin hacer nada
@@SALIR_PAUSA:
	ld	a,[PAUSA]		; leemos la variable PAUSA
	cp	1			; si es 1 es que hemos pulsado la tecla "P"...
	jr	z,@@EN_PAUSA		; SI? seguimos en pausa
	ld	a,1			; else
	ld	[PAUSA],a		; ponemos la variable PAUSA=1 pulsada

	jr	BuclePrincipal		; salimos de la pausa y vamos al Bucle Principal del juego

@@MENU_OBJETOS:
	ld	a,[PAUSA]		; leemos la variable PAUSA
	cp	1			; si es 1 es que hemos pulsado de nuevo la tecla "F1"...
	jp	z,BuclePrincipal	; ...nos vamos y seguimos con Bucle Principal del juego.
	ld	a,1
	ld	[PAUSA],a		; variable PAUSA=1 pulsada

; Borrar toda la tabla de ATRs en VRAM para que no se vean los sprites mientras mostramos el texto
	call	BORRA_ATRs_SPRs		; mini-rutina que borra los ATRs de los SPRs

; mostramos el menu de objetos en medio de la pantalla
	ld	hl,MENU_OBJETOS		; origen buffer en RAM del menu de objetos
	ld	de,NAMTBL+(7*32)	; destino linea 7 columna 0 de la NAMTBL
	ld	bc,10*32		; 10 lineas de 32 CHRs
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

@@VER_MENU:
	ld	a,[NEWKEY+6]		; leemos la ROW 6 del teclado
	bit	5,a			; leemos el bit 5 de la ROW 6 tecla "F1"
	jr	z,@@SALIR_MENU		; SI? salimos del menu de objetos
	xor	a			; else
	ld	[PAUSA],a		; variable PAUSA=0 no pulsada
	halt				; una pausita
	call	ANIMA_OBJETOS		; animamos los objetos del juego
	jr	@@VER_MENU		; seguimos viendo el menu de objetos mientras no pulsemos "F1"

@@SALIR_MENU:
	ld	a,[PAUSA]		; leemos la variable PAUSA
	cp	1			; esta pulsada
	jr	z,@@VER_MENU		; seguimos en el menu de objetos
	ld	a,1			
	ld	[PAUSA],a		; ponemos la variable PAUSA=1 pulsada

; quitamos el menu de objetos mostrando de nuevo la pantalla en uso
	ld	hl,bufferNAM+(7*32)	; origen buffer en RAM de la NAMTBL
	ld	de,NAMTBL+(7*32)	; destino linea 7 columna 0 de la NAMTBL
	ld	bc,10*32		; 10 lineas de 32 CHRs
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

	jp	BuclePrincipal		; Bucle Principal del juego

;---------------------------------------------------------

;---------------------------------------------------------
; inicializacion de todas las variables del juego
VAR_JUEGO:
	xor	a		; ld a,0
	ld	[VOLVER],a	; ponemos a 0 la pulsacion de retorno para los textos
	ld	[MIRA_A],a	; n de SPR del prota 0 mirara a la derecha con pies cerrado
	ld	[ANDA],a	; prota no anda estara quieto 
	ld	[ESTADO],a	; sin caida
	ld	[LEIDO],a	; borra buffer de la tecla leida
	ld	[CURoJOY],a	; primero leeremos los cursores
	ld	[ALTURA],a	; contador de la caida en altura a 0
	ld	[TIEMPO],a	; contador de tiempo de inmunidad a 0
	ld	[ACCIONES],a	; acciones del prota a 0 sin accciones
	ld	[BOLEANA],a	; variable para varios cometidos
	ld	[CONTADOR],a	; variable para contar varios propositos
	ld	[COLISION],a	; no hay colision al empezar
	ld	[PARALIZADOR],a	; no tenemos paralizadores al empezar
	ld	[PARALIZA_BCD],a; mostraremos 00 en el menu de objetos en paralizadores
	ld	[LLAVE_BCD],a	; la llave de la cloacas en el menu de objetos a 00 en BCD
	ld	[MAPA],a	; variable para contar las partes del mapa a 0
	ld	[MAPA_BCD],a	; el numero de partes del mapa en el menu de obetos a 00 en BCD
	ld	[PARALIZA],a	; no se paralizaran enemigos
	ld	[PAUSA],a	; la tecla PAUSA "P" a no pulsada
	ld	[EN_HISTORIA],a	; el en juego se animaran los objetos en los textos
;	ld	[FLICKER],a	; puntero para el flickering a 0
	ld	a,1
	ld	[SALTO_OK],a	; el prota podra saltar
	ld	[SE_MATA],a	; no se mata en la caida
	ld	[CLOACA],a	; no se podra entrar a las cloacas
	ld	[NOTXT_COR],a	; mostrar texto al recoger el primer corazon
	ld	[NOTXT_POC],a	; mostrar texto al recoger la primera pocion
	ld	[NOTXT_PAR],a	; mostrar texto al recoger el primer paralizador
;	ld	a,99		; 99 vidas
	ld	a,10		; 10 vidas
	ld	[VIDAS],a	; numero de vidas del prota
;	ld	a,$99		; 99 vidas
	ld	a,$10		; 10 vidas
	ld	[VIDAS_BCD],a	; numero de vidas del prota en BCD
	xor	a
	ld	[PUNTOS],a      ; 00
	ld	[PUNTOS+1],a	; 00
	ld	[PUNTOS+2],a	; 00 = PUNTOS = 000000

	ld	[MAXPUNT],a	; 00
	ld	[MAXPUNT+1],a	; 00
	ld	a,$01		
	ld	[MAXPUNT+2],a	; 01 = MAXPUNT = 010000

; pantalla inicial del juego al empezar
	ld	a,10
	ld	[NUM_PANTA],a	; numero de pantalla inicial 10

; coordenadas X e Y iniciales donde sale el prota al empezar el juego
	ld	a,167		; coordenada Y inicial del prota
	ld	[coordY],a	
	ld	a,5		; coordenada X inicial del prota
	ld	[coordX],a

; descomprimir la tabla de objetos de todo el juego y dejarla en RAM
	ld	hl,tblOBJETOS	; origen
	ld	de,bufferOBJ	; destino
	call	unpack		; rutina descompresora pletter de rom a ram

; Sprites vacios para no atravesar los marcadores y la cloaca
; los llevamos de ROM al buffer de ATRs de los SPRs en RAM
	ld	hl,TBL_VACIOS	; origen
	ld	de,bufATRsSPRs	; destin	
	ld	bc,8*4		; 8 Sprites por 4 valores de ATRs
	ldir			; hazlo

	ret			; salimos de la rutina VAR_JUEGO
;---------------------------------------------------------

;---------------------------------------------------------
; INICIALIZA EL MODO DE PANTALLA Y COLORES
;---------------------------------------------------------
; BASIC: COLOR 15,1,1
; Establecer los colores
INIT_MODE_SCx:
	ld	hl,FORCLR	; Variable del Sistema
	ld	[hl],15		; Color del primer plano 15=blanco
	inc	hl		; FORCLR+1
	ld	[hl],0		; Color de fondo 0=transparente
	inc	hl		; FORCLR+2
	ld	[hl],0		; Color del borde 0=transparente
; call INITXT		; 06Ch - BIOS - Initialize VDP to 40x24 Text Mode - set SCREEN 0
; call INIT32		; 06Fh - BIOS - Initialize VDP to 32x24 Text Mode - set SCREEN 1
	call	INIGRP		; 072h - BIOS - Initialize VDP to Graphics Mode - set SCREEN 2
; call INIMLT		; 075h - BIOS - Initialize VDP to Multicolour Mode - set SCRREN 3
;
; SCREEN 0 : texto de 40 x 24 con 2 colores
; SCREEN 1 : texto de 32 x 24 con 16 colores
; SCREEN 2 : graficos de 256 x 192 pixeles con 16 colores
; SCREEN 3 : graficos de 64 x 48 pixeles con 16 colores
;
; Esto es para quitar el sonido que emite el msx cuando se pulsa una tecla
	xor	a		; ld a,0
	ld	[CLIKSW],a	; Variable BIOS desactivar sonido teclas

; Desactivar las teclas de funcion
	call	ERAFNK		; 0CCh - BIOS - Erase function key display 

; Sprites 16x16 no ampliados
;	ld	bc,E201h	; C=01 N de registro, B=E2h 11100010b  valor a escribir
	ld	bc,(11100010b<<8)|1	; C=01 N de registro, B=E2h 11100010b  valor a escribir
	call	WRTVDP		; 047h - BIOS - Write to any VDP register

	ret			; salimos de la rutina INIT_MODE_SCx
;---------------------------------------------------------


;---------------------------------------------------------
; COLOCA LOS GRAFICOS EN LA VRAM para los menus
; Set de Caracteres,logo JumpinG y logo DIMENSION Z
; ademas de todos los colores de los graficos
;---------------------------------------------------------
GFXmenus:
; Esto lo realizamos para que no se vea nada en la pantalla
; Mientras colocamos los CHR y los Colores en la VRAM 
	call	DISSCR			; 041h - BIOS - Disable screen

; Descomprimir los grficos para los menus
	ld	hl,CHRs_MENUS		; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el buffer de CHRs de RAM en VRAM
; tercio 1
	ld	de,CHRTBL		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM
; tercio 2
	ld	de,CHRTBL+2048		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM
; tercio 3
	ld	de,CHRTBL+4096		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Descomprimir los colores para los menus 
	ld	hl,CLRs_MENUS		; origen
	ld	de,bufferCHR	 	; destino
	call	unpack			; rutina descompresora pletter de rom a ram			

; Colocar el buffer de CLRs de RAM en VRAM
; 1 tercio
	ld	de,CLRTBL		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM
; 2 tercio
	ld	de,CLRTBL+2048		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM
; 3 tercio
	ld	de,CLRTBL+4096		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Esto lo realizamos para que se muestre de nuevo la pantalla.
	call    ENASCR			; 044h - BIOS - Enable screen
	
	ret				; salimos de la rutina GFXmenus
	
;---------------------------------------------------------

;---------------------------------------------------------
; COLOCA LOS GRAFICOS EN LA VRAM PARA EL JUEGO
; CHRs y CLRs para los 3 tercios
; y todos los sprites del juego
;---------------------------------------------------------
GFXgame:
; Esto lo realizamos para que no se vea nada en la pantalla
; Mientras colocamos los CHR y los Colores en la VRAM 
	call	DISSCR			; 041h - BIOS - Disable screen

; Descomprimir los CHRs para el juego del tercio 1
	ld	hl,CHRs_GAME1		; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el buffer de CHRs de RAM en VRAM
; 1 tercio
	ld	de,CHRTBL		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Colocar el buffer de CHRs de RAM en VRAM
; 2 tercio
	ld	de,CHRTBL+2048		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Descomprimir los CLRs de los CHRs para el juego del tercio 1
	ld	hl,CLRs_GAME1		; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el buffer de CLRs de RAM en VRAM
; 1 tercio
	ld	de,CLRTBL		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Colocar el buffer de CLRs de RAM en VRAM
; 2 tercio
	ld	de,CLRTBL+2048		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Descomprimir los CHRs para el juego del tercio 3
	ld	hl,CHRs_GAME3		; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el buffer de CHRs de RAM en VRAM
; 3 tercio
	ld	de,CHRTBL+4096		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Descomprimir los CLRs de los CHRs para el juego del tercio 3
	ld	hl,CLRs_GAME3		; origen
	ld	de,bufferCHR	 	; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Colocar el buffer de CLRs de RAM en VRAM
; 3 tercio
	ld	de,CLRTBL+4096		; Direccion de destino
	call	AVRAM			; Mini-Rutina LDIRVM

; Descomprimir los sprites del protagonista en bufferCHR
	ld	hl,GFX_SPR_PROTA	; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; colocar los sprites del protagonista en la SPRTBL en VRAM
	ld	hl,bufferCHR		; direccion de los bytes de los SPRs del prota
	ld	de,SPRTBL		; destino la SPRTBL
	ld	bc,16*32		; 16 Sprites del prota por 32 bytes por sprite
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

; Descomprimir los sprites de los enemigos en bufferCHR
	ld	hl,GFX_SPR_ENE		; origen
	ld	de,bufferCHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; colocar los sprites de los enemigos en la SPRTBL en VRAM
	ld	hl,bufferCHR		; direccion de los bytes de los SPRs enemigos
	ld	de,SPRTBL+(POS_SPR*32)	; destino la SPRTBL
	ld	bc,(12*4)*32		; 12 Enemigos por 4 animaciones por 32 bytes de cada sprite
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

; Descomprimir el menu oculto de objetos en ROM y dejarlo en RAM
	ld	hl,NAM_MENU_OBJETOS	; origen
	ld	de,MENU_OBJETOS		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Descomprimir los objetos animados CHRs de ROM a RAM
	ld	hl,OBJETOS_CHRc		; origen
	ld	de,OBJETOS_CHR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Descomprimir los objetos animados CLRs de ROM a RAM
	ld	hl,OBJETOS_CLRc		; origen
	ld	de,OBJETOS_CLR		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; Esto lo realizamos para que se muestre de nuevo la pantalla.
	call    ENASCR			; 044h - BIOS - Enable screen

; Descomprimir la tabla de pulsaciones del modo DEMO en bufferCHR
	ld	hl,tblDEMO		; origen
	ld	de,bufferCHR	 	; destino
	ld	[PUNTERO],de		; ponemos el puntero al principio de la tabla
	call	unpack			; rutina descompresora pletter de rom a ram			

	ret				; salimos de la rutina GFXgame
	
;---------------------------------------------------------

;---------------------------------------------------------
; Colocar el bufferCHR de RAM en VRAM
; mini-rutina ENTRADA DE=direccion de destino
AVRAM:
	ld	hl,bufferCHR		; Direccion de origen
	ld	bc,256*8		; Numero de CHRs
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory
	ret
;---------------------------------------------------------

;---------------------------------------------------------
; Borrar los ATRs de los SPRs en VRAM para que no se vean en pantalla
; borramos los ATRs del prota y de los enemigos
BORRA_ATRs_SPRs:
	ld	hl,SPRATR+(8*4)		; Direccin origen en VRAM
	ld	bc,7*4			; n de bytes a rellenar
	xor	a			; a=0 - Valor a rellenar
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte 
	ret				; salimos de la rutina BORRA_ATRs_SPRs
;---------------------------------------------------------

;---------------------------------------------------------
; MENU DE MI LOGO
;---------------------------------------------------------
MI_LOGO:
; Esto lo realizamos para que no se vea nada en la pantalla
; Mientras colocamos los CHR y los Colores en la VRAM 
	call	DISSCR			; 041h - BIOS - Disable screen

; Descomprimir el Menu de mi Logotipo en BufferNAM
	ld	hl,NAM_MI_LOGO		; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora Pletter de rom a ram
	
; Colocar la pantalla del logo de Dimension Z en la NAMTBL
	call	bufNAMaVRAM		; Mini-Rutina que lleva bufferNAM a VRAM

; Esto lo realizamos para que se muestre de nuevo la pantalla.
	call    ENASCR			; 044h - BIOS - Enable screen

; Pausa para que se vea el Logo
	ld	b,100			; valor de la pausa
	call	BUCLE_RETARDO		; rutina que realiza una pausa y sale al pulsar botones

	ret				; salimos de la rutina MI_LOGO
;---------------------------------------------------------

;---------------------------------------------------------
; MENU PRINCIPAL DEL JUEGO
;---------------------------------------------------------
MENU_GAME:
; Descomprimir el Menu del Juego en BufferNAM
	ld	hl,NAM_MENU_GAME	; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora Pletter de rom a ram

	call	CORTINA_ENTRA		; cortinilla de entrada de DER. a IZQ.

; inicializo las variables que usamos en el menu principal del juego
	ld	a,1
	ld	[PULSADO],a
	xor	a
	ld	[BOLEANA],a
	ld	[CONTADOR],a

; hacer parpadear el PULSA PARA EMPEZAR a velocidad lenta
; y comprobar las pulsaciones de los botones para salir del menu
	ld	b,255			; valor del bucle del PULSA PARA EMPEZAR
BUCLE_MENU_GAME:
	push	bc			; guardamos el valor del bucle en la pila
	halt
	call	FLASH_PULSA_PARA	; hace parpadear el texto PULSA PARA EMPEZAR
	call	MIRA_BOTONES		; miramos si pulsamos botones
	pop	bc			; recuperamos el valor del bucle de la pila
	ld	a,[VOLVER]		; vamos a mirar si hubo pulsacion de los  botones
	cp	1			; si se pulso el valor es 1
	ret	z			; SI? salimos del MENU_GAME
	djnz	BUCLE_MENU_GAME		; else continuamos en el bucle 255 veces

	ret				; salimos de la rutina MENU_GAME

;------------------------------------------------
; Rutina que hace parpadear PULSA PARA EMPEZAR
; a velocidad lenta
FLASH_PULSA_PARA:
	ld 	a,[CONTADOR]		; leemos el contador
	inc	a			; le sumamos 1
	ld 	[CONTADOR],a		; y lo almacenamos
	cp	19			; ha parpadeado 19 veces el boton?
	ret	nz			; NO? volmeos al menu del juego
	xor	a			; else
	ld	[CONTADOR],a		; ponemos a 0 el la variable CONTADOR
	ld	a,[BOLEANA]		; variable para saber si borrar o pintar el texto
	inc	a			; le sumamos 1
	and	1			; si es 2 la ponemos a 0
	ld	[BOLEANA],a		; y la almacenamos
	cp	1			; es 1?
	jr	z,@@BORRA_TXT		; vamos a borrar el texto del PULSA PARA EMPEZAR
					; else pintamos el texto del PULSA PARA EMPEZAR
@@PONE_TXT:
; LOCATE 14,7: PRINT "PULSA PARA EMPEZAR"
	ld	hl,TXT_PULSA		; Direccin donde tenemos el texto
IF (IDIOMA==1)
	ld	de,NAMTBL+(14*32)+7	; LOCATE 14,7 en la NAMBTL en VRAM
	ld	bc,18			; Numero de CHR que tiene el texto
ELSE
	ld	de,NAMTBL+(14*32)+10	; LOCATE 14,10 en la NAMBTL en VRAM
	ld	bc,13			; Numero de CHR que tiene el texto
ENDIF
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory
	ret				; salimos de la rutina @@PONE_TXT

; LOCATE 14,7: PRINT "                  " TEXTO CON ESPACIOS para borrar
@@BORRA_TXT:
	ld	hl,TXT_BLANCO		; Direccin donde tenemos el texto
IF (IDIOMA==1)
	ld	de,NAMTBL+(14*32)+7	; LOCATE 14,7 en la NAMBTL en VRAM
	ld	bc,18			; Numero de CHR que tiene el texto
ELSE
	ld	de,NAMTBL+(14*32)+10	; LOCATE 14,10 en la NAMBTL en VRAM
	ld	bc,13			; Numero de CHR que tiene el texto
ENDIF
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

	ret				; salimos de la rutina @@BORRA_TXT
;---------------------------------------------------------

;---------------------------------------------------------
; MENU DE LA HISTORIA DEL JUEGO
;---------------------------------------------------------
MENU_HISTORIA:
;--------------------------------------
; WYZ
; descomprimir la musica de la historia del juego en RAM
	ld	hl,SONG_3	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la cancion de la historia del juego
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
; WYZ
;--------------------------------------

	ld	a,1			; mientras estamos en este menu no animaremos objetos
	ld	[EN_HISTORIA],a		; almacenamos 1 en la variable EN_HISTORIA

; Descomprimir los textos de la HISTORIA del juego de ROM a RAM
	ld	hl,TXTs_HISTORIA	; origen
	ld	de,TXT_CUENTO		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; LOCATE 0,12 : PRINT "HISTORIA" en la NAMTBL
	ld	hl,TXT_HISTORIA		; Direccin donde tenemos el texto
IF (IDIOMA==1)
	ld	de,NAMTBL+12		; LOCATE 0,12 en la NAMBTL en VRAM
	ld	bc,8			; Numero de CHR que tiene el texto
ELSE
	ld	de,NAMTBL+13		; LOCATE 0,13 en la NAMBTL en VRAM
	ld	bc,5			; Numero de CHR que tiene el texto
ENDIF
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

	ld	de,TXT_CUENTO		; direccion del texto a imprimir
	ld	hl,NAMTBL+(3*32)	; direccion de la NAMTBL en VRAM donde empieza a escribir
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

; Bucle de retardo y salimos si pulsamos
	ld	b,150			; valor del bucle
	call	BUCLE_RETARDO		; rutina de retardo y comprobacion de botones

; borrar la zona de la NAMTBL en VRAM donde vamos a poner el texto
	ld	hl,NAMTBL+(3*32)	; LOCATE 3,0 en la NAMBTL en VRAM
	ld	bc,19*32		; n de bytes a rellenar 19 filas por 32 CHRs
	xor	a			; a=0 - Valor a rellenar
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte 

	ld	de,TXT_CUENTO1		; direccion del texto a imprimir
	ld	hl,NAMTBL+(3*32)	; LOCATE 3,0 en la NAMBTL en VRAM
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR

;--------------------------------------
; WYZ
	ld	a,$10			; CADENCIA
	call	@@START_FADE_OUT	; parar la musica de mas a menos
; WYZ
;--------------------------------------

; Bucle de retardo y salimos si pulsamos
	ld	b,100			; valor del bucle
	call	BUCLE_RETARDO		; rutina de retardo y comprobacion de botones

	ret				; salimos de la rutina MENU_HISTORIA

;------------------------------------------------

;---------------------------------------------------------
; MENU DE CREDITOS DEL JUEGO
;---------------------------------------------------------
MENU_CREDITOS:
; Descomprimir el Menu del Juego en BufferNAM
	ld	hl,NAM_MENU_CREDITOS	; origen
	ld	de,bufferNAM		; destino
	call	unpack			; rutina descompresora pletter de rom a ram

; llevar el bufferNAM de RAM a la NAMTBL en VRAM
	call	CORTINA_ENTRA		; cortinilla de entrada de DER. a IZQ.

; Bucle de retardo y salimos si pulsamos
	ld	b,200			; valor del bucle
	call	BUCLE_RETARDO		; rutina de retardo y comprobacion de botones

	ret				; salimos de MENU_CREDITOS

;------------------------------------------------


;------------------------------------------------
; Comprobar si hemos pulsamos en el teclado la
; barra espaciadora o el boton 1 del Joystick 1
;------------------------------------------------
MIRA_BOTONES:
	xor	a			; primero leemos el teclado 
	call	GTTRIG			; 0D8h - BIOS - Get trigger status
	or	a			; se ha pulsado la barra espaciadora?
	jr	nz,@@PULSA_BOTON	; SI? vamos a @@PULSA_BOTON
	ld	a,1			; ahora vamos a leer el joystick 1
	call	GTTRIG			; 0D8h - BIOS - Get trigger status
	or	a			; se ha pulsado el boton 1 del Joystick
	jr	nz,@@PULSA_BOTON	; SI? vamos a @@PULSA_BOTON
	xor	a			
	ld	[PULSADO],a		; variable PULSADO = 0 no se pulso
	
	ret				; salimos de la rutina MIRA_BOTONES

@@PULSA_BOTON:
	ld	a,[PULSADO]		; leemos la variable PULSADO
	cp	1			; miramos si esta a 1?
	ret	z			; SI? salimos de MIRA_BOTONES
	ld	a,1			; ponemos la variable VOLVER a 1
	ld	[VOLVER],a		; pasa indicar que se pulso en ese menu
	ld	[PULSADO],a		; ponemos la variable PULSADO a 1

	ret				; salimos de la rutina MIRA_BOTONES

;---------------------------------------------------------

;---------------------------------------------------------
BUCLE_RETARDO:
	push	bc		; almacenamos el retardo en la pila
	call	MIRA_BOTONES	; vamos a mirar si hemos pulsado espacio o boton
	pop	bc		; recuperamos el retardo de la pila
	ld	a,[VOLVER]	; leemos la variable para saber si hemos pulsado
	cp	1		; 1 = SI pulsado
	ret	z		; SI? salimos de la rutina BUCLE_RETARDO
	halt
	halt			; una pausa
	halt
	djnz	BUCLE_RETARDO	; repetimos el numero de veces especificado en B=RETARDO

	ret			; salimos de la rutina BUCLE_RETARDO

;---------------------------------------------------------

;----------------------------------------------------------
; cortinilla de entrada de derecha a izquierda
; muestra columna a columna la pantalla que esta
; en bufferNAM llevandola a la NAMTBL en VRAM
;----------------------------------------------------------
CORTINA_ENTRA:
	ld	hl,NAMTBL		; destino la NAMTBL
	ld	de,bufferNAM		; origen bufferNAM
	ld	b,32			; n de Columnas
@@BUCLE:
	push	bc
	halt
	ld	b,24			; n de Filas 24
	push	hl
	push	de
@@COPIA:
	push	bc
	push	hl
	push	de
	ld	a,[de]
	call	WRTVRM			; 04Dh - BIOS Write byte to VRAM
	pop	hl
	ld	bc,32
	add	hl,bc
	ex	de,hl
	pop	hl
	add	hl,bc
	pop	bc
	djnz	@@COPIA			; bucle seguir copiando CHRs
	pop	de
	pop	hl
	inc	de
	inc	hl
	pop	bc
	djnz	@@BUCLE			; Bucle pantalla completa

	ret				; salimos de CORTINA_ENTRA
;----------------------------------------------------------

;----------------------------------------------------------
; Cortinilla de salida de izquierda a derecha
; borra la NAMTBL columna a columna de IZQ. a DER.
;----------------------------------------------------------
CORTINA_SALE:
	ld	hl,NAMTBL	; destino la NAMTBL
	ld	b,32		; n de Columnas
@@BUCLE:
	halt
	push	bc
	push	hl
	ld	b,24		; n de Filas 24
@@BORRAR:
	push	bc
	push	hl
	xor	a
	call	WRTVRM		; 04Dh - BIOS Write byte to VRAM
	pop	hl
	ld	bc,32
	add	hl,bc
	pop	bc
	djnz	@@BORRAR	; bucle seguir borrando CHRs
	pop	hl
	dec	hl
	pop	bc
	djnz	@@BUCLE		; bucle pantalla completa

	ret			; salimos de la rutina CORTINA_SALE
;----------------------------------------------------------

;------------------------------------------------------------
; Rutina encargada de colocar la pantalla y los enemigos
; toma la variable NUM_PANTA para saber el n de pantalla
; descomprime de ROM a RAM la pantalla y enemigos
;------------------------------------------------------------
PANTALLAS:
	ld	a,[NUM_PANTA]	; leemos el numero de pantalla
	sla	a		; lo multiplicamos por 2 ya que es un DW
	ld	c,a		; lo pasamos a c
	ld	b,0		; b lo dejamos a 0
	ld	hl,tblPANTAS	; tabla con las direcciones de las pantallas
	add	hl,bc		; sumamos a la tabla el numero de la pantalla
	ld	e,[hl]		; tomamos la direccion de la pantalla byte bajo
	inc	hl		; uno mas a la tabla de direcciones
	ld	d,[hl]		; tomamos la direccion de la pantalla byte alto
	push	de		; almacenamos la direccion de la pantalla en DE
	pop	hl		; recuperamos la direccion de la pantalla en HL

; Descomprimir la pantalla xx en bufferNAM en RAM
;	ld	HL,viene calculada mas arriba
	ld	de,bufferNAM+(2*32) ; destino fila 2 columna 0 en bufferNAM
	call	unpack		; rutina descompresora Pletter de rom a ram

	call	OBJETOS		; colocar los objetos en la pantalla

	ld	a,[NUM_PANTA]	; leemos la pantalla en uso
	cp	12		; es la pantalla n12?
	jr	nz,@@CERRADA	; NO? no hay que abrir la CLOACA vamos a @@CERRADA
	ld	a,[CLOACA]	; leemos la variable CLOACA para saber si tenemos la llave
	or	a		; comprobamos si es 0?
	jr	nz,@@CERRADA	; SI? no tiene la llave, no abrimos la cloaca

; vamos a cambiar los graficos de los 2 CHRs de la tapa de la cloaca para que el prota caiga
	ld	hl,bufferNAM+(23*32)+25  ; direccion del 1 CHR de la tapa de la cloaca en bufferNAM
	ld	a,130		; CHR n130 tapa de la cloaca abierta CHR 1
				; abrimos la cloaca pintando 2 CHR que no son..
	ld	[hl],a		; solidos con la tapa abierta para que el prota caiga.
	inc	hl		; le sumamos uno a la direccion bufferNAM para que apunte al 2 CHR
	inc	a		; le sumamos uno al CHR n 130 pasando al 131 tapa de la cloaca abierta CHR 2
	ld	[hl],a		; ponemos el segundo CHR en bufferNAM

@@CERRADA:
; llevar la pantalla en uso de bufferNAM de RAM a la NAMTBL en VRAM 22 lineas
	call	bufNAMaVRAM2	; miniRutina que lleva el bufferNAM a VRAM desde la linea 2

; al cambiar de pantalla desactivamos el paralizador para que los enemigos se muevan
	xor	a		; a=0
	ld	[PARALIZA],a	; desactivamos el paralizador de enemigos

	ld	a,[NUM_PANTA]	; leemos la variable para saber en que pantalla estamos
	cp	2		; miramos si hemos bajado a las cloacas?
	jr	z,MUSICA2	; SI? vamos a poner la musica para las cloacas
	cp	20		; miramos si es 20 
	jr	nc,BORRA_4_ATRs	; si es mayor de 20 vamos a borrar los 4 fantasmas de las cloacas
	jr	c,PONE_4_ATRs	; si es menor de 20 vamos a poner los 4 fantasmas de las cloacas

MUSICA2:
	ld	a,[QUESUENA]	; leemos la variable QUESUENA para saber si ya esta sonando
	cp	2		; es 2? ya esta sonando la musica de las cloacas
	ret	z		; y salimos de la rutina PANTALLAS sin poner de nuevo la musica

;--------------------------------------
; WYZ
	LD	A,$08
	CALL	@@START_FADE_OUT	; parar la musica de mas a menos
; WYZ
;--------------------------------------

; mostrar el texto de ayuda al entrar a las cloacas
	call	BORRA_SCR		; borra la parte de la pantalla donde ponemos el texto y quita SPRs
	ld	de,TXT_CLOACA		; direccion del texto a imprimir
	ld	hl,NAMTBL+(10*32)	; direccion de la NAMTBL en VRAM donde empieza a escribir
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR
	call	REPONE_SCR		; volver a colocar la parte de la pantalla que habiamos borrado

;--------------------------------------
; WYZ
; descomprimir la musica del juego para las cloacas y dejarla en RAM
	ld	hl,SONG_2	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la cancion del juego para las cloacas
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
	ld	a,2		; 
	ld	[QUESUENA],a	; ponemos la variable que esta sonando la musica de las cloacas
; WYZ
;--------------------------------------

	ret			; salimos de la rutina PANTALLAS
;----------------------------------------------------------

;----------------------------------------------------------
; borrar los ATRs de los 4 SPRs que ocultan la bajada a la cloaca
; colocando en esa posicion los fantasmas para no atravesar el marcador
BORRA_4_ATRs:
	ld	hl,TBL_VACIOS		; origen
	ld	de,bufATRsSPRs+(4*4)	; destino	
	ld	bc,4*4			; 4 SPRs por 4 valores de los ATRs
	ldir				; hazlo
	ret				; salir de la rutina PANTALLAS

;----------------------------------------------------------
; sprites vacios para no atravesar el grafico de la tapa de la cloaca
; los llevamos de ROM al buffer de ATRs de los SPRs en RAM
PONE_4_ATRs:
	ld	hl,TBL_VACIOS+(4*4)	; origen
	ld	de,bufATRsSPRs+(4*4)	; destino	
	ld	bc,4*4			; 4 SPRs por 4 valores de los ATRs
	ldir				; hazlo
	ret				; salimos de la rutina PANTALLAS

;----------------------------------------------------------

;----------------------------------------------------------
; mini-rutina
bufNAMaVRAM:
; llevar la pantalla en uso de bufferNAM de RAM a la NAMTBL en VRAM 24 lineas
	halt			    ; espera al VBLANK
	ld	hl,bufferNAM	    ; origen bufferNAM en RAM
	ld	de,NAMTBL	    ; destino NAMTBL en VRAM
	ld	bc,32*24	    ; 32 columnas por 24 lineas
	call	LDIRVM		    ; 05Ch - BIOS  Copy block to VRAM, from memory
	ret			    ; salimos de la rutina
;----------------------------------------------------------

;----------------------------------------------------------
; mini-rutina
bufNAMaVRAM2:
; llevar la pantalla en uso de bufferNAM de RAM a la NAMTBL en VRAM 22 lineas
	halt			    ; espera al VBLANK
	ld	hl,bufferNAM+(2*32) ; origen fila 2 columna 0 de bufferNAM
	ld	de,NAMTBL+(2*32)    ; destino fila 2 columna 0 de la NAMTBL en VRAM
	ld	bc,32*22	    ; 32 columnas por 22 lineas
	call	LDIRVM		    ; 05Ch - BIOS  Copy block to VRAM, from memory
	ret			    ; salimos de la rutina
;----------------------------------------------------------

;----------------------------------------------------------------
; rutina encargada de colocar los marcadores iniciales del juego
; mostrar el texto en la pantalla de PREPARADO:
; sacar la pantalla donde empieza el juego con una cortinilla
;----------------------------------------------------------------
PREPARADO:
; borrar el contenido de bufferNAM
	ld	hl,bufferNAM		; origen
	ld	de,bufferNAM+1		; origen + 1
	ld	bc,32*24		; numero de bytes 32 columnas por 24 filas
	ld	[hl],0			; valor a escribir
	ldir				; hazlo

; LOCATE 1,1: PRINT "PUNTUACION    VIDAS    MAX.PUNT." en bufferNAM
	ld	hl,TXT_MARCADOR		; direccin donde tenemos  el texto
	ld	de,bufferNAM		; LOCATE 1,1 en bufferNAM
	ld	bc,32			; numero de CHR que tiene el texto
	ldir				; llevar de ROM a RAM

; LOCATE 2,1: PRINT "0000000        10        0000000" en BufferNAM
	ld	hl,TXT_PUNTOS		; direccin donde tenemos  el texto
	ld	de,bufferNAM+(1*32)	; LOCATE 2,1 en bufferNAM en RAM
	ld	bc,32			; Numero de CHR que tiene el texto
	ldir				; llevar de ROM a RAM

; llevar bufferNAM de RAM a VRAM 24 lineas
	call	bufNAMaVRAM		; Mini-Rutina que lleva el bufferNAM a VRAM

	ld	a,[DEMO]		; leemos la variable
	or	a			; es 0?
	ret	z			; SI? salimos del menu mostrando solo los marcadores
	 
; LOCATE 12,12: PRINT "PREPARADO:" en bufferNAM
	ld	hl,TXT_LISTO		; Direccin donde tenemos  el texto
IF (IDIOMA==1)
	ld	de,bufferNAM+(10*32)+12	; LOCATE 12,12 en bufferNAM
	ld	bc,10			; Numero de CHR que tiene el texto
ELSE
	ld	de,bufferNAM+(10*32)+10	; LOCATE 12,10 en bufferNAM
	ld	bc,11			; Numero de CHR que tiene el texto
ENDIF
	ldir				; llevar de ROM a RAM

; llevar bufferNAM de RAM a VRAM 24 lineas
	call	bufNAMaVRAM		; Mini-Rutina que lleva el bufferNAM a VRAM

;Bucle Nivel
	ld	b,255			; valor de repeticion del bucle
BUC_NIVEL:
	halt				; una pausa
	djnz	BUC_NIVEL		; repite mientras B no sea 0

; Descomprimir la pantalla 10 en bufferNAM en RAM
	ld	hl,PANTA10		; origen
	ld	de,bufferNAM+(2*32)	; destino
	call	unpack			; rutina descompresora Pletter

	call	CORTINA_ENTRA		; cortinilla de entrada de DER. a IZQ.

	ret				; salimos de la rutina PREPARADO
;----------------------------------------------------------

;------------------------------------------------
; G E S T I O N   D E L   P R O T A G O N I S T A
; aqui se mueve al protagonista y se realizan
; todas las posibles acciones ademas se comprueban
; las colisiones del prota con el fondo de la pantalla.
;------------------------------------------------
MOVER_PROTA:

; vamos a comprobar si el prota tiene que morir
	ld	a,[ACCIONES]		; leemos la variable ACCIONES
	cp	1			; miramos si es 1=MUERTO?
	jp	z,@@MURIENDO		; SI? vamos a que MUERA

; vamos a comprobar si el prota esta con inmunidad
	cp	2			; miramos si la variable ACCIONES=2 INMUNIDAD?
	call	z,@@INMUNIDAD		; SI? vamos a seguir con la inmunidad

; vamos a comprobar si el prota esta en las escaleras
	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2=prota esta en escaleras?
	jp	z,LEER		; SI? vamos a leer el teclado

; AQUI ESTA LA TEORIA DE LA GRAVEDAD DE ISAAC NEWTON
; el prota siempre cae salvo que debajo de sus pies encuentre algo solido
	ld	a,[ESTADO]		; leemos la variable ESTADO
	cp	2			; miramos si es 2=en salto?
	jr	z,@@CAIDA		; SI? vamos a que caiga
					; else
; Comprobar que hay debajo de los pies del prota y dejar de caer
	call	DEBAJO			; mirar CHRs debajo del prota
	ld	a,[COLISION]		; leemos si hay colision
	or	a			; es 0? 
	jr	nz,@@SIN_CAIDA		; NO? entonces hay suelo y deja de caer

; si hay caida desde la calle a la cloaca por la tapa que al caer se quede en la escalera
	call	DEBAJO_E		; vamos a mirar si hay escalera 2 CHR por debajo de los pies del prota
	ld	a,[COLISION]		; 0 - No hay escalera : 1 - Si hay escalera
	or	a			; es 0?
	jr	z,@@SIGUE		; SI? no hay escalera y seguimos cayendo vamos @@SIGUE 
	ld	a,48			; ponemos la primera animacion del prota en la escalera
	ld	[MIRA_A],a
	ld	a,2			; ponemos ANDA=2 prota en escalera
	ld	[ANDA],a
	ld	a,[coordY]		; leemos la coord.Y del prota 
	add	8			; le sumamos 16 pixeles al prota para ponerlo mas abajo en la escalera
	ld	[coordY],a		; y lo almacenamos
	xor	a			; 
	ld	[ESTADO],a		; cambiamos el estado a sin caida
	jp	LEER			; todo listo vamos a leer teclas
@@SIGUE:
; aqui creamos la gravedad artificial sumando 2 a la coordenada Y del prota
	ld	a,1
	ld	[ESTADO],a		; ESTADO = 1 caida sin salto
	xor	a
	ld	[ANDA],a		; ANDA = 0 ptota no anda
	ld	a,[coordY]		; si esta cayendo sin parabola...
	inc	a			; descendemos mas rapido
	inc	a			; de 2 en 2 pixeles
	ld	[coordY],a		; almacenamos la coord.Y del prota
; aqui controlaremos desde que altura caemos para que muera el prota
	ld	a,[ALTURA]		; leemos la variable ALTURA
	inc	a			; le sumamos uno
	ld	[ALTURA],a		; y la guardamos
	cp	40			; si llega a 40 es que ha caido 80 pixeles 
	jr	c,@@NO_MUERE		; mientras sea menor de 40 el prota no muere
	ld	a,[ACCIONES]		; leemos la varible ACCIONES
	cp	2			; miramos si es 2=prota con inmunidad?
	jr	z,@@NO_MUERE		; SI? cae con inmunidad y no muere el prota
	xor	a			; else activamos la variable SE MATA = 0 
	ld	[SE_MATA],a		; para que cuando termine de caer se mate
@@NO_MUERE:
	jr	@@CAIDA			; vamos a seguir con la caida

; todo esto lo realizamos para despues de caer dejar siempre al prota con las piernas cerradas
@@SIN_CAIDA:
	ld	a,[MIRA_A]		; leemos la vaviable MIRA_A
	cp	12			; miramos si el prota mira a la derecha con las piernas abiertas
	jr	z,@@SC_DER		; SI? lo mandamos a poner las piernas cerradas mirando a la derecha
	cp	36			; miramos si el prota mira a la izquierda con las piernas abiertas
	jr	z,@@SC_IZQ		; SI? lo mandamos a poner las piernas cerradas mirando a la izquierda
	jr	@@FIN_SC		; else vamos a @@FIN_SC
@@SC_IZQ:
	ld	a,24			; numero de animacion del prota con las piernas cerradas a la izquierda
	ld	[MIRA_A],a
	jr	@@FIN_SC		; vamos a @@FIN_SC
@@SC_DER:
	xor	a			; numero de animacion del prota con las piernas cerradas a la derecha
	ld	[MIRA_A],a
@@FIN_SC:
	ld	a,[SE_MATA]		; aqui llegamos cuando ha terminado de caer el prota
	or	a			; leemos la variable SE_MATA es 0?
	call	z,@@SE_MATA		; SI? lo mandamos a que el prota tiene que morir
	xor	a	
	ld	[ESTADO],a		; variable ESTADO = 0 Sin caida
	ld	[ALTURA],a		; variable ALTURA = 0 empezara a contar de nuevo desde que altura caemos
	ld	[COLISION],a		; quitamos la colision cuando termina de caer
@@CAIDA:
; comprobar si se mueve
	ld	a,[ESTADO]		; leemos la variable ESTADO
	or	a			; si el ESTADO es distinto de 0... 
	jp	nz,@@MOVER		; ...vamos a mover al prota 
	jp	LEER			; else vamos a leer teclas o joystick
@@MURIENDO:
	ld	a,184			; ponemos el n de sprite del prota muerto
	ld	[MIRA_A],a		; n de Sprite 16 Prota Muerto
	ld	a,[coordY]		; leemos la coordenada Y del prota
	cp	40
	jr	c,@@UN_PIXEL
	dec	a			; la animacion del sprite del prota muerto
@@UN_PIXEL:
	dec	a			; subira de 2 en 2 pixeles hacia arriba
; aqui controlamos cuando el prota sube hasta el final de la pantalla
	ld	[coordY],a		; almacenamos la coordenada Y del prota
	cp	2			; miramos si es 2
	jr	c,@@FIN_MUERTO		; si la coord.Y es menor de 2 Fin de muerte
	jp	@@LISTO			; else todo listo vamos a que se vea

@@FIN_MUERTO:
	xor	a			; si estaba saltando en el momento de morir
	ld	[ESTADO],a		; lo dejamos a ESTADO = 0 sin caida 
	ld	a,[viejaCY]		; recuperamos la coord.Y donde estaba el prota
	ld	[coordY],a		; antes de morir y la almacenamos
	ld	a,[viejaANI]		; recuperamos la ultima animacion del prota
	ld	[MIRA_A],a		; antes de morir y la almacenmos
	ld	a,2			; como acaba de morir activamos la inmunidad
	ld	[ACCIONES],a		; ponemos la variable ACCIONES = 2 INMUNIDAD del prota
	ld	hl,VIDAS_BCD		; HL apunta a la posicion de memoria donde tenemos el numero de vidas en BCD 
	ld	b,1			; B = 1
	ld	a,[hl]			; leemos el numero de vidas en BCD
	sub	a,b			; le restamos una vida
	daa				; ajuste decimal del acumulador ya que trabajamos en BCD
	ld	[hl],a			; una vez quitada una vida para el marcador la guardamos

	ld	b,1			; numero de bytes
	ld	de,VIDAS_BCD		; direccion donde estan las vidas en formato BCD
	ld	hl,bufferNAM+15+(1*32)	; direccion en bufferNAM donde ponemos el numero de vidas
	call	BCD2TEXTO		; transformamos el numero de vidas de BCD a ASCII

	ld	a,[VIDAS]		; leemos el numero de vidas
	dec	a			; le restamos una
	ld	[VIDAS],a		; y la almacenamos
	or	a			; miramos si hemos llegado a 0 vidas
	jr	z,FIN_JUEGO		; SI? se acabo seguir jugando
	jp	@@LISTO			; else todo listo vamos a que se vea

FIN_JUEGO:
;--------------------------------------
; WYZ
	ld	a,$08
	call	@@START_FADE_OUT	; paramos la musica de mas a menos
; WYZ
;--------------------------------------

	call	MARCADOR		; mostramos el marcador actualizado
	call	CLRSPR			; 069h - BIOS - Clear all sprites

; vamos a borrar la pantalla omitiendo los marcadores
	ld	hl,NAMTBL+(2*32)	; inicio en la linea 3 de la NAMTBL
	ld	bc,22*32		; tamao 22 lineas x 32 CHR
	xor	a			; rellenar con 0
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte

	ld	b,255			; valor de repeticion
@@pausa:
	halt				; esperar a la interrupcion
	djnz	@@pausa			; repetir mientras B no sea 0

; LOCATE 12,10: PRINT "FIN DE JUEGO"
	ld	hl,TXT_FINJUEGO		; direccin donde tenemos  el texto
IF (IDIOMA==1)
	ld	de,NAMTBL+(11*32)+10	; LOCATE 11,10 en la NAMBTL en VRAM
	ld	bc,12			; Numero de CHR que tiene el texto
ELSE
	ld	de,NAMTBL+(11*32)+12	; LOCATE 11,12 en la NAMBTL en VRAM
	ld	bc,9			; Numero de CHR que tiene el texto
ENDIF
	call	LDIRVM			; 056h - BIOS  Copy block to VRAM, from memory

;--------------------------------------
; WYZ
; descomprimir la musica del gameover y dejarla en RAM
	ld	hl,SONG_5	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la cancion del game over
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
; WYZ
;--------------------------------------

; una pausa para que se vea el mensaje de FIN DE JUEGO
	ld	b,255			; valor del bucle
@@bucle:
	halt				; esperar a la interrupcion
	djnz	@@bucle			; repetir mientras B no sea 0
	jp	INI_ROM			; ahora lo mandamos al principio como si arracara la ROM de nuevo

@@INMUNIDAD:
	ld	a,[TIEMPO]		; contador de tiempo de inmunidad
	inc	a			; uno mas
	and	127			; si llega a 127 lo ponemos a 0
	ld	[TIEMPO],a		; lo almacenamos
	or	a			; se ha puesto a 0 el tiempo?
	ret	nz			; NO? salimos de inmunidad
					; else
	xor	a			; quitamos la inmunidad
	ld	[ACCIONES],a		; ACCIONES = 0 Sin acciones

; si termina la inmunidad vamos a ver si esta en algun sitio que le mata como encima de los pinchos por ejemplo
	call	ENCIMA			; miramos encima del prota
	call	A_LA_DER		; miramos a la derecha del prota
	call	DEBAJO			; miramos debajo del prota
	call	A_LA_IZQ		; miramos a la izquierda del prota
	ret				; salimos de la rutina @@INMUNIDAD

; aqui venimos si hemos pulsado el espaciado o el boton 1 del Joystick para usar un paralizador
FUEGO:
	ld	a,[PARALIZA]		; leemos la variable PARALIZA
	or	a			; comprobamos si existe paralizacion
	ret	nz			; y salimos de la rutina si ya esta activada
					; else
	ld	a,[PARALIZADOR]		; leemos si tenemos paralizadores
	or	a			; es 0?
	ret	z			; SI? no tenemos paralizadores y salimos de la rutina
	dec	a			; else le restamos 1 paralizador
	ld	[PARALIZADOR],a		; y lo almacenamos
	ld	hl,PARALIZA_BCD		; HL apunta a la posicion de memoria donde tenemos el numero de paralizadores en BCD 
	ld	b,1			; B=1
	ld	a,[hl]			; leemos el numero actual de paralizadores en BCD
	sub	a,b			; le restamos 1 paralizador
	daa				; ajuste decimal del acumulador ya que trabajamos en formato BCD
	ld	[hl],a			; una vez restado un paralizador lo almacenamos en la variable PARALIZA_BCD

	ld	b,1			; numero de bytes
	ld	de,PARALIZA_BCD		; direccion donde estan las paralizadores en formato BCD
	ld	hl,MENU_OBJETOS+8+(3*32); direccion en Menu de Objetos donde mostramos el numero de paralizadores
	call	BCD2TEXTO		; transformamos el numero de paralizadores de BCD a ASCII
	
	ld	a,255			; ponemos el tiempo para paralizar a los enemigos en 255 casi 6 segundos
	ld	[PARALIZA],a		; y lo almacenamos

	ld	bc,1F07h		; ponemos el borde blanco para el efecto del flash
	call	WRTVDP			; 047h - BIOS - Write to any VDP register
	halt				; una pausita para que se vea el cambio
	halt
	ld	bc,1107h		; ponemos de nuevo el borde en color negro
	call	WRTVDP			; 047h - BIOS - Write to any VDP register
;--------------------------------------
; WYZ
	LD	B,SFX_DISPARO		; seleccionamos el efecto de sonido del salto
	CALL	INICIA_EFECTO		; reproducir el efecto de sonido.
; WYZ
;--------------------------------------

	ret				; salimos de la rutina FUEGO

;---------------------------------------------------------
; vamos a leer las teclas de los cursores o el Joystick 1
; para realizar todos los posibles movimientos del prota
;---------------------------------------------------------
LEER:
	ld	a,[DEMO]		; leemos la variable DEMO
	or	a			; es 0? estamos en modo demo
	jp	z,MUEVE_DEMO		; SI? no leemos teclas y vamos a mover la demo

	ld	a,[CURoJOY]		; que leemos cursores o joystick 1
	call	GTSTCK			; 0D5h - BIOS - Get Cursor o Joystick status
;	call	GRABA_DEMO		; rutina para capturar las pulsaciones
ANIMAR:
	ld	[LEIDO],a		; almacenamos el valor leido para otros propositos

; Comprobar si se ha pulsado izquierda
@@IZQUIERDA:
	cp	7			; se pulso izquierda?
	jr	nz,@@DERECHA		; si es NO, vamos a mirar DERECHA
@@ABA_IZQ:				; aqui venimos cuando pulsamos ABAJO_IZQUIERDA
	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2=prota en escalera
	jp	z,@@SIN_MOV		; SI? no hacemos nada y vamos a @@SIN_MOV 
	ld	a,[LEIDO]		; leemos la lectura guardada de los CUR. o el JOY.
	cp	8			; se pulso salto en diagonal arriba-izquierda?
	jr	z,@@PASAi		; SI? vamos a izquierda sin que se pueda saltar
	ld	a,1			; else vamos a izquierda y se podra saltar.
	ld	[SALTO_OK],a		; SALTO=1 se podra saltar
@@PASAi:
	ld	a,24			; ponemos la primera animacion del prota a la izquierda con pies juntos
	ld	[MIRA_A],a		;
	ld	a,-1			; ANDA = -1 anda izquierda
	ld	[ANDA],a		; 
	jp	@@MOVER			; vamos a moverlo

; Comprobar si se ha pulsado derecha
@@DERECHA:
	cp	3			; se pulso derecha?
	jr	nz,@@SALTO		; si es NO, vamos a mirar SALTO
@@ABA_DER:				; aqui venimos cuando pulsamos ABAJO_DERECHA
	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2=prota en escalera
	jp	z,@@SIN_MOV		; SI? no hacemos nada y vamos a @@SIN_MOV 
	ld	a,[LEIDO]		; leemos la lectura guardada de los CUR. o el JOY.
	cp	2			; se pulso salto en diagonal arriba-derecha
	jr	z,@@PASAd		; SI? vamos a derecha sin que se pueda saltar
	ld	a,1			; else vamos a derecha y se podra saltar.
	ld	[SALTO_OK],a		; SALTO=1 se podra saltar
@@PASAd:
	xor	a			; ponemos la primera animacion del prota a la derecha con pies juntos
	ld	[MIRA_A],a
	ld	a,1			; ANDA = 1 anda derecha
	ld	[ANDA],a		; 
	jp	@@MOVER			; vamos a moverlo

; Comprobar si se ha pulsado arriba
@@SALTO:
	cp	1			; se pulso arriba?
	jp	nz,@@SALTO_IZQ		; si es NO, vamos a mirar diagonal arriba-izquierda

	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2= prota en escalera
	jr	z,@@SUBE_ES		; SI? vamos a que siga subiendo la escalera
					; else
	call	ENCIMA_E		; miramos antes de saltar si hay escalera
	ld	a,[COLISION]		; 0 - si hay escalera | 1 - no hay escalera
	or	a			; miramos si es 0
	jr	z,@@SI_SALTA		; SI? no hay escalera y vamos a realizar el SALTO
	ld	a,48			; ponemos la primera animacion del prota en la escalera
	ld	[MIRA_A],a
	ld	a,2			; ponemos ANDA=2 prota en escalera
	ld	[ANDA],a
	jp	@@MOVER			; vamos a moverlo

@@SI_SALTA:	
	ld	a,[SALTO_OK]		; leemos la variable SALTO_OK
	or	a			; es 0?
	jp	z,@@LISTO		; SI? no podemos saltar y vamos a @@LISTO
					; else
;--------------------------------------
; WYZ
	LD	B,SFX_SALTO		; seleccionamos el efecto de sonido del salto
	CALL	INICIA_EFECTO		; reproducir el efecto de sonido.
; WYZ
;--------------------------------------

	ld	a,[MIRA_A]		; leemos la variable MIRA_A
	or	a			; miramos si el prota mira a la derecha con las piernas rectas
	jr	z,@@SAL_DER		; SI? lo mandamos a poner las piernas abiertas mirando a la derecha
	cp	24			; miramos si el prota mira a la izquierda con las piernas rectas
	jr	z,@@SAL_IZQ		; SI? lo mandamos a poner las piernas abiertas mirando a la izquierda
	jr	@@SAL_PASA		; else vamos a @@SAL_PASA
@@SAL_IZQ:
	ld	a,36			; ponemos la segunda animacion del prota a la izquierda con pies abiertos
	ld	[MIRA_A],a
	jr	@@SAL_PASA		; vamos a @@SAL_PASA
@@SAL_DER:
	ld	a,12			; ponemos la segunda animacion del prota a la derecha con pies abiertos
	ld	[MIRA_A],a
@@SAL_PASA:
	xor	a		
	ld	[SALTO_OK],a		; SALTO_OK = 0 No se podra saltar
	ld	[ANDA],a		; ANDA = 0 No anda
	ld	a,2
	ld	[ESTADO],a		; ESTADO = 2 saltando 
	ld	a,50	
	ld	[SALTO],a		; SALTO = 50 bytes de la parabola
	jp	@@MOVER			; todo listo vamos a que se vea

; aqui venimos si en vez de saltar el prota tiene que subir escaleras
@@SUBE_ES:
; vamos a mirar si encima del prota hay escalera para seguir subiendo
	ld	a,[coordX]		; leemos la coord.X del prota
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota	
	add	ALTO_PROTA-9		; le sumamos el alto del prota 16 - 9 para que sea el 2 CHR donde esta el prota 
	ld	c,a			; ahora en BC tenemos las coords.X e Y debajo del prota CHR 1 
	call	LEE_CHR			; leemos el CHR en bufferNAM en esas coordenadas
	cp	209			; miramos si el CHR es el ladrillo azul punteado...
	jp	z,@@MOVER		; SI? ...la cloaca esta cerrada y no movemos al prota
	cp	193			; miramos si el CHR es el de la escalera
	jr	nz,@@FIN_SUBE		; NO? dejamos de subir escalera
	ld	a,[coordY]		; leemos la cordenada Y del prota
	dec	a			; le restamos uno para que prota suba por la escalera	
	ld	[coordY],a		; y la almacenamos
	cp	9			; miramos si la coordenada Y es menor de 9
	jr	c,@@CALLE		; SI? quiere decir que hemos subido a la calle
	jp	@@MOVER			; else vamos a mover al prota
@@CALLE:
	ld	a,192-8			; situamos al prota en la coordenada Y 192-8
	ld	[coordY],a		; y la almacenamos
	ld	a,215			; situamos al prota en la coordenada X 207
	ld	[coordX],a		; y no se caiga por el agujero de la cloaca otra vez.

	ld	a,[NUM_PANTA]		; leemos la pantalla en uso
	add	10			; le sumamos 10 para situarnos en la pantalla encima de la actual
	ld	[NUM_PANTA],a		; y la almacenamos
	call	PANTALLAS		; mostramos la nueva pantalla

;--------------------------------------
; WYZ
	ld	a,$06			; valor de bajada
	call	@@START_FADE_OUT	; parar la musica de mas a menos
; WYZ
;--------------------------------------

; mostrar el texto de ayuda al salir de las cloacas
	call	BORRA_SCR		; borra la parte de la pantalla donde ponemos el texto y quita SPRs
	ld	de,TXT_CALLE		; direccion del texto a imprimir
	ld	hl,NAMTBL+(10*32)	; direccion de la NAMTBL en VRAM donde empieza a escribir
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR
	call	REPONE_SCR		; volver a colocar la parte de la pantalla que habiamos borrado

;--------------------------------------
; WYZ
; descomprimir la musica principal del juego y dejarla en RAM
	ld	hl,SONG_1	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la cancion del juego en la calle
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
	ld	a,1		; 
	ld	[QUESUENA],a	; ponemos en la variable QUESUENA la musica del juego en la calle
; WYZ
;--------------------------------------

; aqui venimos cuando el prota ha terminado de subir la escalera
@@FIN_SUBE:
	xor	a			; ponemos la primera animacion del prota a la derecha con pies cerrados
	ld	[MIRA_A],a		; y la almacenamos
	ld	[ANDA],a		; cambiamos el estado del prota de escaleras a anda a la derecha
	ld	[SALTO_OK],a		; para que cuando termine de subir no saltemos hasta soltar la tecla 
	ld	a,[coordY]		; leemos la coordenada Y del prota
	sub	ALTO_PROTA+3		; le restamos el alto del prota+3 para que se quede justo en suelo
	ld	[coordY],a		; y la almacenamos
	jp	@@MOVER			; vamos a mover al prota

; Comprobar si se ha pulsado diagonal arriba-izquierda
@@SALTO_IZQ:
	cp	8			; se pulso diagonal arriba-izquierda
	jr	nz,@@SALTO_DER		; si es NO, vamos a mirar diagonal arriba-derecha

; aqui miramos si el prota esta en escalera para no realizar el salto a la izquierda
	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2=prota en escalera
	jp	z,@@SIN_MOV		; SI? no hacemos nada y vamos a @@SIN_MOV 

; aqui miramos que no salte de nuevo mientras no se suelte la tecla de salto
	ld	a,[SALTO_OK]		; leemos la variable SALTO_OK
	or	a			; es 0? no se puede saltar
	jp	z,@@ABA_IZQ		; SI? vamos a diagonal abajo-izquierda
	xor	a			; else
	ld	[SALTO_OK],a		; ponemos la variable SALTO_OK=0 no se podra saltar

;--------------------------------------
; WYZ
	LD	B,SFX_SALTO		; seleccionamos el efecto de sonido del salto
	CALL	INICIA_EFECTO		; reproducir el efecto de sonido.
; WYZ
;--------------------------------------

	ld	a,36			; ponemos la segunda animacion del prota a la izquierda con pies abiertos
	ld	[MIRA_A],a
	ld	a,-1		
	ld	[ANDA],a		; ANDA = -1 anda izquierda
	ld	a,2
	ld	[ESTADO],a		; ESTADO = 2 saltando
	ld	a,50
	ld	[SALTO],a		; SALTO = 50 bytes de la parabola
	jp	@@MOVER			; todo listo vamos a que se vea

; Comprobar si se ha pulsado diagonal arriba-derecha
@@SALTO_DER:
	cp	2			; se pulso diagonal arriba-derecha
	jr	nz,@@ABAJO		; si es NO, vamos a mirar abajo

; aqui miramos si el prota esta en escalera para no realizar el salto a la izquierda
	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2 = prota en escalera
	jp	z,@@SIN_MOV		; SI? no hacemos nada y vamos a @@SIN_MOV 

; aqui miramos que no salte de nuevo mientras no se suelte la tecla de salto
	ld	a,[SALTO_OK]		; leemos si podemos saltar
	or	a			; es 0? no se puede saltar
	jp	z,@@ABA_DER		; SI? vamos a diagonal abajo-derecha
	xor	a			; else
	ld	[SALTO_OK],a		; ponemos la variable SALTO_OK=0 no se podra saltar

;--------------------------------------
; WYZ
	LD	B,SFX_SALTO		; seleccionamos el efecto de sonido del salto
	CALL	INICIA_EFECTO		; reproducir el efecto de sonido.
; WYZ
;--------------------------------------

	ld	a,12			; ponemos la segunda animacion del prota a la derecha con pies abiertos
	ld	[MIRA_A],a		
	ld	a,1
	ld	[ANDA],a		; ANDA = 1 anda derecha
	ld	a,2
	ld	[ESTADO],a		; ESTADO = 2 saltando
	ld	a,50
	ld	[SALTO],a		; SALTO = 50 bytes de la parabola
	jr	@@MOVER			; todo listo vamos a que se vea

; Comprobar si se ha pulsado abajo
@@ABAJO:
	cp	5			; se pulso abajo
	jr	nz,@@ABAJO_DER		; si es NO, vamos a mirar abajo-derecha

; aqui vamos a mirar si el prota no esta en la escalera, pero si tiene una escalera debajo de sus pies
	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2? prota esta en escalera?
	jr	nz,@@MIRA2		; NO? vamos a mirar 2 CHR mas abajo del prota
					; else
; aqui estamos en la esclera y vamos a mirar si debajo del prota hay escalera para seguir bajando
	ld	a,[coordX]		; leemos la coord.X del prota
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota	
	add	ALTO_PROTA		; le sumamos el alto del prota para mirar los CHRs justo debajo de sus pies 
	ld	c,a			; ahora en BC tenemos las coords.X e Y debajo del prota CHR 1 
	call	LEE_CHR			; leemos en CHR que hay en bufferNAM en las cordenadas BC
	cp	193			; es el CHR de la escalera?
	jr	nz,@@FIN_BAJA		; NO? vamos a @@FIN_BAJA
	ld	a,[coordY]		; else leemos la coordenada X del prota
	inc	a			; le sumamos 1
	ld	[coordY],a		; y la almacenamos
	jr	@@MOVER			; todo listo vamos a que se vea
@@FIN_BAJA:
	xor	a			; ponemos la primera animacion del prota a la derecha con pies cerrados
	ld	[MIRA_A],a		; y la almacenamos
	xor	a			; prota ya no esta en escalera
	ld	[ANDA],a		; variable ANDA=0 no anda 
	ld	a,[coordY]		; leemos la coord.X del prota
	dec	a			; le restamos uno para que se quede justo en el suelo
	ld	[coordY],a		; y la almacenamos
	jr	@@MOVER			; todo listo vamos a que se vea
@@MIRA2:
	call	DEBAJO_E		; vamos a mirar si hay escalera 2 CHR por debajo de los pies del prota
	ld	a,[COLISION]		; 0 - No hay escalera : 1 - Si hay escalera
	or	a			; es 0?
	jr	z,@@SIN_MOV		; SI? no podemos bajar y vamos a @@SIN_MOV
	ld	a,48			; ponemos la primera animacion del prota en la escalera
	ld	[MIRA_A],a
	ld	a,2			; ponemos ANDA=2 prota en escalera
	ld	[ANDA],a
	ld	a,[coordY]		; leemos la coord.Y del prota 
	add	16			; le sumamos 16 pixeles al prota para ponerlo mas abajo en la escalera
	ld	[coordY],a		; y lo almacenamos
	jr	@@MOVER			; todo listo vamos a que se vea

; Comprobar si se ha pulsado diagonal abajo-derecha
@@ABAJO_DER:
	cp	4			; se pulso diagonal abajo-derecha
	jr	nz,@@ABAJO_IZQ		; si es NO, vamos a mirar abajo-izquierda
	jp	@@ABA_DER		; else lo mandamos como si hemos pulsado derecha

; Comprobar si se ha pulsado diagonal abajo-izquierda
@@ABAJO_IZQ:
	cp	6			; se pulso diagonal abajo-izquierda
	jr	nz,@@SIN_MOV		; si es NO, vamos a Sin Movimientos
	jp	@@ABA_IZQ		; else lo mandamos como si hemos pulsado izquierda

; Aqui lleganos si no ha habido ninguna pulsacion
@@SIN_MOV:
; vamos a mirar si el prota esta en la escalera para no quitar el estado
	ld	a,[ANDA]		; leemos la variable ANDA
	cp	2			; miramos si es 2=prota en escalera
	jr	z,@@PASA		; SI? no hacemos nada y vamos a @@PASA 

	xor	a			; aqui quitamos el estado
	ld	[ANDA],a		; ANDA = 0 no anda

	ld	a,1			; si llegamos aqui es porque no se pulsa nada
	ld	[SALTO_OK],a		; y ponemos la variable a se puede saltar
@@PASA:
; Hemos terminado de leer los cursores ahora vamos a leer el Joystick
	ld	a,[CURoJOY]		; venimos de mirar los CURSORES
	inc	a			; CURoJOY de 0 a 1
	and	1			; cuando sea 2 lo dejamos en 0
	ld	[CURoJOY],a		; la almacenamos
	cp	1			; es 1? vamos a mirar el JOYSTICK 1
	jp	z,LEER			; SI? vamos a leer de nuevo los movimientos 
					; else no es 1 nada mas que leer ya hemos leido CUR. y JOY.
@@MOVER:
; Comprobar si podemos movernos por el escenario o fondo de pantalla
	ld	a,[ANDA]		; leemos la variable ANDA
	or	a			; es 0? 
	jr	z,@@PODEMOS		; SI? no hay movimientos y podemos

@@MIRA_DER:
; Comprobar si es posible el movimiento a la izquierda
	cp	1			; miramos si ANDA = 1 anda a la DERECHA
	jr	nz,@@MIRA_IZQ		; NO? vamos a @@MIRA_IZQ
	call	A_LA_DER		; comprobar si se puede ir a la derecha
	ld	a,[COLISION]		; 0-No hay colision : 1-Hay colision
	or	a			; es 0?
	jr	nz,@@YA_MOVIDO		; NO? hay colision y no movemos al prota
	ld	hl,coordX		; HL apunta a la direccion de la coord.X del prota
	inc	[hl]			; le sumamos 1 a la coordenada X del prota
	jr	@@PODEMOS		; todo listo vamos a que se vea

; Comprobar si es posible el movimiento a la derecha
@@MIRA_IZQ:
	cp	-1			; miramos si ANDA = -1 anda a la IZQUIERDA
	jr	nz,@@YA_MOVIDO		; NO? vamos a @@YA_MOVIDO
	call	A_LA_IZQ		; comprobar si se puede ir a la izquierda
	ld	a,[COLISION]		; 0-No hay colision : 1-Hay colision
	or	a			; es 0?
	jr	nz,@@YA_MOVIDO		; NO? hay colision y no movemos al prota
	ld	hl,coordX		; HL apunta a la direccion de la coord.X del prota
	dec	[hl]			; le restamos 1 a la coordenada X del prota
	jr	@@PODEMOS		; todo listo vamos a que se vea

@@YA_MOVIDO:
	ld	a,[ESTADO]		; leemos la variable ESTADO
	cp	2			; miramos si es 2 = saltando
	jr	nz,@@PODEMOS		; NO? vamos a @@PODEMOS
	ld	a,1
	ld	[ESTADO],a		; ESTADO = 1  caida sin salto
	xor	a
	ld	[ANDA],a		; ANDA = 0 no anda
	ld	[COLISION],a		; ponemos la variable COLISION=0 si ya hemos movido
@@PODEMOS:
; Comprobamos el salto
	ld	a,[ESTADO]		; leemos la variable ESTADO
	cp	2			; miramos si es 2 = saltando
	jr	nz,@@LISTO		; NO? vamos a todo @@LISTO 
	ld	a,[SALTO]		; numero de bytes de la parabola del salto
	or	a			; ha terminado la parabola del salto?
	jr	z,@@FIN_SALTO		; SI, vamos a Finalizar el Salto
	dec	a			; un byte menos quedara para la parabola
	ld	[SALTO],a		; la almacenamos
	ld	hl,TBL_SALTO		; apuntamos a la tabla de la parabola del salto
	ld	c,a			; el contador de en que posicion esta el salto
	ld	b,0			; lo pasamos a BC
	add	hl,bc			; y le lo sumamos a a la direccion de la tabla de la parabola
	ld	b,[hl]			; leemos el valor de la parabola del salto
	ld	a,[coordY]		; leemos la coord.Y del prota
	add	b			; y se lo aplicamos a la coord.Y del prota
	ld	[coordY],a		; guardamos la coord.Y ya modificada con el dato de la parabola
	ld	a,[SALTO]		; leemos la variable SALTO
	cp	25			; a partir de aqui el salto empieza a caer
	jr	c,@@BAJANDO		; si es menor de 25 esta cayendo vamos a @@BAJANDO
					; else
@@SUBIENDO:
	call	ENCIMA			; vamos a mirar si podemos subir
	ld	a,[COLISION]		; 0-No hay colision : 1-Hay colision
	or	a			; es 0?
	jr	nz,@@FIN_SALTO		; NO? hay colision y vamos a @@FIN_SALTO	
	jr	@@LISTO			; else vamos a @@LISTO

@@BAJANDO:
	call	DEBAJO			; vamos a mirar si podemos bajar
	ld	a,[COLISION]		; 0-No hay colision : 1-Hay colision
	or	a			; es 0?
	jr	nz,@@FIN_SALTO		; NO? hay colision y vamos a @@FIN_SALTO
	jr	@@LISTO			; else vamos a @@LISTO

@@FIN_SALTO:
	ld	a,[MIRA_A]		; leemos la variable MIRA_A
	cp	12			; miramos si el prota mira a la derecha con las piernas abiertas
	jr	z,FIN_DER		; SI? lo mandamos a poner las piernas cerradas mirando a la derecha
	cp	40			; miramos si el prota mira a la izquierda con las piernas abiertas
	jr	z,FIN_IZQ		; SI? lo mandamos a poner las piernas cerradas mirando a la izquierda
	jr	FIN_PASA		; else vamos a FIN_PASA
FIN_IZQ:
	ld	a,24			; ponemos la primera animacion del prota a la izquierda con pies cerrados
	ld	[MIRA_A],a
	jr	FIN_PASA		; vamos a todo listo
FIN_DER:
	xor	a			; ponemos la primera animacion del prota a la derecha con pies cerrados
	ld	[MIRA_A],a
FIN_PASA:
	xor	a			; ld a,0
	ld	[SALTO],a		; SALTO = 0 bytes de la parabola
	ld	[ESTADO],a		; ESTADO = 0 - sin caida
	ld	[ANDA],a		; ANDA = 0 - no anda 
	ld	[COLISION],a		; COLISION = 0 - sin colision

;--------------------------------------
; Esta es la parte encargada de cambiar el ATR del prota en RAM actualizando
; las animaciones, cambios de coordenadas, colores y otras acciones del prota
;--------------------------------------
@@LISTO:
	ld	a,[ACCIONES]		; leemos la variable ACCIONES
	cp	1			; es 1? prota esta muerto
	jr	z,@@C_MUERTE		; SI? vamos a poner el color para muerte
	cp	2			; es 2? prota esta inmune
	jr	z,@@C_INMUNE		; SI? vamos a poner el color para inmunidad 
	jr	@@SU_COLOR		; else vamos a @@SU_COLOR
@@C_MUERTE:
	ld	a,15			; ponemos el color 1 del prota en blanco 
	ld	[SPR+(8*4)+3],a		; ATR del prota SPR8 n de COLOR
	ld	a,15			; ponemos el color 2 del prota en blanco
	ld	[SPR+(9*4)+3],a		; ATR del prota SPR9 n de color
	jr	MIRA_SALIDAS		; vamos a MIRA_SALIDAS
@@C_INMUNE:
	ld	a,[BOLEANA]		; aqui realizamos lo siguiente con esta variable contiene 0 o 1
	inc	a			; cuando esta a 0 la ponemos a 1
	and	1			; y cuando esta a 1 la ponemos a 0
	ld	[BOLEANA],a		; la guardamos para la proxima vez
	or	a			; si es 0 ponemos los 2 colores del prota en transparente
	jr	z,@@C_NEGRO		; para producir el efecto de parpadeo en la inmunidad
	jr	@@SU_COLOR		; else lo dejamos con su color
@@C_NEGRO:
;	xor	a			; ponemos el color 1 del prota en 0=transparente
	ld	a,15			; ponemos el color 1 del prota en 15=blanco
	ld	[SPR+(8*4)+3],a		; ATR del prota SPR8 n de COLOR
;	xor	a			; ponemos el color 2 del prota en 0=transparente
	ld	a,14			; ponemos el color 2 del prota en 14=gris
	ld	[SPR+(9*4)+3],a		; ATR del prota SPR9 n de COLOR
	jr	MIRA_SALIDAS		; vamos a MIRA_SALIDAS
@@SU_COLOR:
	ld	a,4			; ponemos el color 4 del prota en azul 
	ld	[SPR+(8*4)+3],a		; ATR del prota SPR8 n de COLOR
	ld	a,9			; ponemos el color 9 del prota en carne
	ld	[SPR+(9*4)+3],a		; ATR del prota SPR9 n de COLOR
	ld	a,1			; ponemos el color 1 del prota en negro
	ld	[SPR+(14*4)+3],a	; ATR del prota SPR14 n de COLOR
MIRA_SALIDAS:
	ld	a,[coordY]		; leemos la coord.Y del prota
	cp	2			; es 2?
	jp	c,@@PANTA_ARR		; si es menor de 2 vamos a poner la nueva pantalla de arriba
	cp	190			; es 192?
	jp	nc,@@PANTA_ABA		; si es menor de 190 vamos a poner la nueva pantalla de abajo

	ld	a,[coordX]		; leemos la coord.X del prota
	cp	4			; es 4?
	jr	c,@@PANTA_IZQ		; si es menor de 4 vamos a poner la nueva pantalla de la izquierda
	cp	255			; es 255?
	jp	z,@@PANTA_DER		; si es 255 vamos a poner la nueva pantalla a la derecha

@@OK:
	sub	4			; aqui le restamos 4 pixeles a la coord X para...
					; ...centrar al prota para precisar mas las colisiones
	ld	[SPR+(8*4)+1],a		; guardamos la coord.X del ATR del SPR8 del color 1 del prota 
	ld	[SPR+(9*4)+1],a		; guardamos la coord.X del ATR del SPR9 del color 2 del prota
	ld	[SPR+(14*4)+1],a	; guardamos la coord.X del ATR del SPR14 del color 3 del prota
	ld	a,[coordY]		; leemos la coord.Y del prota
	ld	[SPR+(8*4)+0],a		; guardamos la coord.Y del ATR del SPR8 del color 1 del prota
	ld	[SPR+(9*4)+0],a		; guardamos la coord.Y del ATR del SPR9 del color 2 del prota
	ld	[SPR+(14*4)+0],a	; guardamos la coord.Y del ATR del SPR14 del color 3 del prota
; vamos a mirar si el prota esta muriendo para pausar la animacion subiendo
	ld	a,[ACCIONES]		; leemos la variables ACCIONES
	cp	1			; es 1?
	jr	z,@@ANI_Y		; SI? vamos a @@ANI_Y

; vamos a mirar si el prota no esta andando para no cambiar la fase de animacion
	ld	a,[ANDA]		; variable hacia donde anda el prota
	or	a			; es 0? no esta andando
	jr	z,@@NO_ANIMA		; SI? no cambiamos la fase de animacion del prota
					; else
; vamos a mirar si estamos saltando o cayendo para no cambiar la fase de animacion
	ld	a,[ESTADO]		; leemos la variable ESTADO: 0 no salta, 1 caida, 2 saltando
	or	a			; miramos si es 0?
	jr	nz,@@NO_ANIMA		; NO? no cambiamos la fase de animacion del prota
					; else
; vamos a mirar si estamos en las escaleras para pausar la animacion subiendo o bajando
	ld	a,[ANDA]		; miramos si el prota esta en las escaleras
	cp	2			; es 2? esta en las escaleras?
	jr	nz,@@ANI_X		; NO? vamos a controlar la pausa de la animacion en la coord.X
	ld	a,[coordY]		; leemos la coord.Y del prota
	and	4			; mientras no sea 4 la dejamos a 0 
	sla	a			; lo multiplicamos por 2. cuando 0 x 2 = 0  y cuando es 4 x 2 = 8...
	jr	@@NO_ANIMA
; esto es comun para cuando sube la muerte y para cuando sube o baja escaleras
@@ANI_Y:
	ld	a,[coordY]		; leemos la coord.Y del prota
	and	4			; mientras no sea 4 la dejamos a 0 
	ld	b,a			; lo pasamos a B
	ld	a,[MIRA_A]		; leemos la variable MIRA_A
	add	b			; le sumamos 8 o 0, y se queda igual o apunta a la segunda animacion del prota
	ld	[SPR+(8*4)+2],a		; guardamos en el ATR del SPR8 n de color 1 del prota
	ld	[SPR+(9*4)+2],a		; guardamos en el ATR del SPR9 n de color 2 del prota
	ld	[SPR+(14*4)+2],a	; guardamos en el ATR del SPR14 n de color 3 del prota
	ret
; pausar la animacion del prota para que sea mas lenta cuando esta andando
@@ANI_X:
	ld	a,[coordX]		; leemos la coord.X del prota
	and	4			; mientras no sea 4 la dejamos a 0 
	jr	z,@@NO_ANIMA
	ld	a,12
@@NO_ANIMA:
	ld	b,a			; lo pasamos a B
	ld	a,[MIRA_A]		; leemos la variable MIRA_A
	add	b			; le sumamos 8 o 0, y se queda igual o apunta a la segunda animacion del prota
	ld	[SPR+(8*4)+2],a		; guardamos en el ATR del SPR8 el color 1 el n de SPR del prota
	add	4			; le sumamos 4 para que apunte al n de SPR del prota del segundo color
	ld	[SPR+(9*4)+2],a		; guardamos en el ATR del SPR9 el color 2 el n de SPR del prota
	add	4			; le sumamos 4 para que apunte al n de SPR del prota del segundo color
	ld	[SPR+(14*4)+2],a	; guardamos en el ATR del SPR14 el color 3 el n de SPR del prota

	ret				; salimos de la rutina ACTUALIZA_ATR y volvemos al menu principal
;--------------------------------------

;--------------------------------------
; C A M B I O S  D E  P A N T A L L A S
; Aqui realizamos los cambios de pantalla
; dependiendo de por donde salga el prota.
;--------------------------------------

; si el prota ha llegado al final de la pantalla en su lado izquierdo vamos a cambiar la pantalla
@@PANTA_IZQ:
	ld	a,[NUM_PANTA]		; leemos el numero de pantalla en uso
	dec	a			; le restamos una pantalla
	ld	[NUM_PANTA],a		; y la almacenamos
	cp	-1			; comprobamos si llegamos al final de las cloacas por la izquieda
	jr	z,@@PANTA_FIN		; SI? vamos a ponerlo al final de las cloacas por la derecha
	cp	9			; final de la planta de calle por la izquierda
	jr	z,@@PANTA_FIN		; SI? vamos a ponerlo al final de la planta de calle por la derecha
	cp	19			; final de la planta 1 de edificios por la izquierda
	jr	z,@@PANTA_FIN		; SI? vamos a ponerlo al final de la planta 1 por la derecha
	cp	29			; final de la planta 2 de edificios por la izquierda
	jr	z,@@PANTA_FIN		; SI? vamos a ponerlo al final de la planta 2 por la derecha
	jr	@@PASA0			; else mostrar una pantalla menos a la izquierda
@@PANTA_FIN:
	add	10			; sumamos 10 pantallas para situarnos al principio de esa planta
	ld	[NUM_PANTA],a
@@PASA0:
	call	PANTALLAS		; mostramos la nueva pantalla
	ld	a,255-5			; situamos al prota en la coordenada 245
	ld	[coordX],a		; y la guardamos
	ret				; salimos de la rutina @@PANTA_IZQ

; si el prota ha llegado al final de la pantalla en su lado derecho vamos a cambiar la pantalla
@@PANTA_DER:
	ld	a,[NUM_PANTA]		; leemos el numero de pantalla en uso
	inc	a			; le sumamos una pantalla
	ld	[NUM_PANTA],a	;	; y la almacenamos
	cp	10			; comprobamos si llegamos al final de las cloacas por la derecha
	jr	z,@@PANTA_INI		; SI? vamos a ponerlo al final de las cloacas por la izquierda
	cp	20			; final de la planta de calle por la derecha
	jr	z,@@PANTA_INI		; SI? vamos a ponerlo al final de la planta de calle por la izquierda
	cp	30			; final de la planta 1 por la derecha
	jr	z,@@PANTA_INI		; SI? vamos a ponerlo al final de las planta 1 por la izquierda
	cp	40			; final de la planta 2 por la derecha
	jr	z,@@PANTA_INI		; SI? vamos a ponerlo al final de las planta 2 por la izquierda
	jr	@@PASA1			; else mostrar una pantalla mas a la derecha
@@PANTA_INI:
	sub	10			; restamos 10 pantallas para situarnos al principio de esa planta
	ld	[NUM_PANTA],a		; y la almacenamos
@@PASA1:
	call	PANTALLAS		; mostramos la nueva pantalla
	ld	a,5			; situamos al prota en la coordenada X 5 
	ld	[coordX],a		; y la almacenamos
	ret				; salimos de la rutina @@PANTA_DER

; si el prota ha llegado al final de la pantalla por la parte de arriba vamos a cambiar la pantalla
@@PANTA_ARR:
	ld	a,[NUM_PANTA]		; leemos la pantalla en uso
	add	10			; le sumamos 10 para situarnos en la pantalla encima de la actual
	ld	[NUM_PANTA],a		; y la almacenamos
	call	PANTALLAS		; mostramos la nueva pantalla
	ld	a,191-8			; situamos al prota en la coodenada Y 183
	ld	[coordY],a		; y la almacenamos
	ret				; salimos de la rutina @@PANTA_ARR

; si el prota ha llegado al final de la pantalla por la parte de abajo vamos a cambiar la pantalla
@@PANTA_ABA:
	ld	a,[NUM_PANTA]		; leemos la pantalla en uso
	sub	10			; le restamos 10 para situarnos en la pantalla debajo de la actual
	ld	[NUM_PANTA],a		; y la almacenamos
	call	PANTALLAS		; mostramos la nueva pantalla
	ld	a,3			; situamos el prota en la coordenada Y 3
	ld	[coordY],a		; y la almacenamos
	ret				; salimos de la rutina @@PANTA_ABA

;---------------------------------------------------

;---------------------------------------------------
; G E S T I O N   D E   L A S   C O L I S I O N E S
; de prota con el escenario o fondo de la pantalla
;---------------------------------------------------
; Mirar colisiones DEBAJO del prota comprobar los 2 CHRs ya que tienes 16 pixeles de ancho
DEBAJO:
; vamos a mirar el primer CHR debajo del prota
	ld	a,[coordX]		; leemos la coord.X del prota
;	cp	4			; esto lo realizamos para no comprobar colisiones cuando el prota...
;	ret	c			; ...esta en el primer CHR de la pantalla salimos de la rutina
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota	
	add	ALTO_PROTA+1		; le sumamos el alto del prota 16 + 1 para que sea el CHR de debajo 
	cp	192			; si la coord.Y es mayor que alto total de la pantalla...
	ret	nc			; ...salimos de la rutina sin mirar colisiones.
	ld	c,a			; ahora en BC tenemos las coords.X e Y debajo del prota CHR 1
	call	LEE_CHR			; en base a las coordenadas localizar el CHR debajo del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	call	COLISIONES2		; leido el CHR vamos a mirar las colisiones con el fondo
	ld	a,[COLISION]		; leemos la variable COLISION
	or	a			; es 0?
	ret	nz			; NO? hemos detectamos colision y salimos de la rutina

; vamos a mirar el segundo CHR debajo del prota 8 pixeles mas a la derecha
	ld	a,[coordX]		; leemos la coord.X del prota
	cp	255-8			; esto lo realizamos para no comprobar colisiones cuando el prota...
	ret	nc			; ...esta en el ultimo CHR de la pantalla salimos de la rutina
	add	8			; le sumamos 8 para que apunte al siguiente CHR a la derecha
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	add	ALTO_PROTA+1		; le sumamos el alto del prota 16 + 1 para que sea el CHR de debajo
	cp	192			; si la coord.Y es mayor que alto total de la pantalla...
	ret	nc			; ...salimos de la rutina sin mirar colisiones.
	ld	c,a			; ahora en BC tenemos las cords.X e Y debajo del prota CHR 2
	call	LEE_CHR			; en base a las coordenadas localizar el CHR debajo del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
COLISIONES2:
	cp	60			; es el CHR del AURA AZUL?
	jp	z,AURA_AZUL		; SI? vamos a AURA_AZUL
	cp	61			; es el CHR del AURA ROJA?
	jp	z,AURA_ROJA		; SI? vamos a AURA_ROJA
	cp	59			; es el CHR del CORAZON?
	jp	z,VIDA			; SI? vamos a VIDA
	cp	47			; es el CHR de la POCION AZUL? 
	jp	z,POCION		; SI? vamos a POCION
	cp	62			; es el CHR del PINCHO 1?
	jp	z,@@CON_COLI		; SI? vamos a @@CON_COLI para que muera
	cp	63			; es el CHR del PINCHO 2?
	jp	z,@@CON_COLI		; SI? vamos a @@CON_COLI para que muera
	cp	44			; es el CHR del PARALIZADOR?
	jp	z,PARALIZAR		; SI? vamos a PARALIZAR
	cp	45			; es el CHR de la LLAVE?
	jp	z,LLAVE			; SI? vamos a LLAVE
	cp	252			; es el CHR del primer fragmento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS
	cp	253			; es el CHR del segundo fragmento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS
	cp	254			; es el CHR del tercer fragmento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS
	cp	255			; es el CHR del cuarto fragmento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS

; aqui comprobamos si el CHR leido esta comprendido entre 1 y 46 que son los solidos
	cp	1			; vamos a mirar sin son solidos
	jr	nc,SOLIDOS2		; si es mayor de 1 vamos a SOLIDOS2
					; else
NOSOLIDOS2:
; Los CHRs no son solidos
	xor	a
	ld	[COLISION],a		; COLISION = 0 no hay colision
	ret				; salimos de la rutina NOSOLIDOS2

SOLIDOS2:
; Los CHRs son solidos
	cp	46			; vamos a mirar si son solidos
	jr	nc,NOSOLIDOS2		; si el CHR leido es mayor de 45 no es solido
	ld	a,1
	ld	[COLISION],a		; COLISION = 1 hay colision
	ret				; salimos de la rutina SOLIDOS2
;--------------------------------------

; vamos a mirar si el prota tiene una ESCALERA 2 CHR mas abajo de sus pies para saber si se podra bajar
DEBAJO_E:
; vamos a mirar el primer CHR debajo del prota
	ld	a,[coordX]		; leemos la coord.X del prota
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota	
	add	ALTO_PROTA+9		; le sumamos el alto del prota 16 + 9 para que sea el 2 CHR de debajo del prota
	ld	c,a			; ahora en BC tenemos las coords.X e Y debajo del prota CHR 1
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR...
					; ...que hay en bufferNAM el resultado viene en el registro A
	cp	193			; es el primer CHR de la escalera?
	jr	nz,NO_ESCALERA		; NO? lo mandamos NO_ESCALERA porque no hay escalera

; vamos a mirar el segundo CHR debajo del prota 8 pixeles mas a la derecha
	ld	a,[coordX]		; leemos la coord.X del prota
	add	8			; le sumamos 8 para que apunte al siguiente CHR a la izquierda
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	add	ALTO_PROTA+9		; le sumamos el alto del prota 16 + 9 para que sea el 2 CHR de debajo del prota
	ld	c,a			; ahora el BC tenemos la cords.X e Y debajo del protam CHR2
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR...
					; ...que hay en bufferNAM el resultado viene en el registro A
	cp	194			; es el segundo CHR de la escalera?
	jr	z,ESCALERA		; SI? vamos a @@ESCALERA porque hay escalera
NO_ESCALERA:
; los CHRs no son escaleras
	xor	a
	ld	[COLISION],a		; COLISION = 0 no es escalera
	ret				; salimos de la rutina
ESCALERA:
; los CHRs son escaleras
	ld	a,1
	ld	[COLISION],a		; COLISION = 1 hay colision
	ret				; salimos de la rutina
;--------------------------------------

; vamos a mirar colisiones ENCIMA del prota comprobar los 2 CHRs ya que tiene 16 pixeles de ancho
ENCIMA:
; vamos a mirar el primer CHR encima del prota
	ld	a,[coordX]		; leemos la coord.X del prota
;	cp	4			; esto lo realizamos para no comprobar colisiones cuando el prota...
;	ret	c			; ...esta en el primer CHR de la pantalla salimos de la rutina
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	cp	15			; si coodenada Y es menor de 15 estamos en los marcadores...
	ret	c			; ...y salimos de la rutina sin mirar colisiones.
	ld	c,a			; ahora en BC tenemos las coords.X e Y encima del prota CHR 1
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR...
					; ...que hay en bufferNAM el resultado viene en el registro A
	call	COLISIONES		; leido el CHR vamos a mirar las colisiones con el fondo
	ld	a,[COLISION]		; leemos la variable COLISION
	or	a			; es 0?
	ret	nz			; NO? hemos detectamos colision y salimos de la rutina

; vamos a mirar el segundo CHR encima del prota 8 pixeles mas a la derecha
	ld	a,[coordX]		; leemos la coord.X del prota
	cp	255-8			; esto lo realizamos para no comprobar colisiones cuando el prota...
	ret	nc			; ...esta en el ultimo CHR de la pantalla salimos de la rutina
	add	8			; le sumamos 8 para que apunte al segundo CHR a la derecha
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	cp	15			; si coodenada Y es menor de 15 estamos en los marcadores...
	ret	c			; ...salimos de la rutina sin mirar colisiones.
	ld	c,a			; ahora en BC tenemos la coords.X e Y encima del prota CHR 2
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR...
					; ...que hay en bufferNAM el resultado viene en el registro A
	jp	COLISIONES		; leido el CHR vamos a mirar las colisiones con el fondo
;--------------------------------------

; vamos a mirar si el prota tiene una ESCALERA en su cabeza mirando los 2 CHRs encima del prota 
ENCIMA_E:
; vamos a mirar el primer CHR encima del prota
	ld	a,[coordX]		; leemos la coord.X del prota
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota	
	ld	c,a			; ahora en BC tenemos las coords.X e Y 2 CHR encima del prota CHR 1
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR encima del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	cp	193			; es el primer CHR de la escalera?
	jr	nz,NO_ESCALERA		; NO? salimos de la rutina ENCIMA_E

; vamos a mirar el segundo CHR encima del prota 8 pixeles mas a la derecha
	ld	a,[coordX]		; leemos la coord.X del prota
	add	8			; le sumamos 8 para que apunte al siguiente CHR a la derecha
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	ld	c,a			; ahora el BC tenemos la cords.X e Y, 2 CHR encima del prota CHR 2
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR encima del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	cp	194			; es el segundo CHR de la escalera?
	jr	z,ESCALERA		; SI? vamos a ESCALERA porque hay escalera
	jr	NO_ESCALERA		; else vamos a NO_ESCALERA porque no hay escalera
;--------------------------------------

; vamos a mirar colisiones a la IZQUIERDA del prota comprobar los 2 CHRs en 3 posiciones por el tema de los saltos
A_LA_IZQ:
; primer CHR a la izquierda del prota
	ld	a,[coordX]		; leemos la coord.X del prota
	sub	1			; le restamos 1 para que sea el CHR a la izquierda del prota
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	cp	191-10			; si la cordenada Y es mayor de 181
	ret	nc			; salimos sin mirar colisiones
	add	1			; le sumamos 1 para ajustes hay veces que se queda un pixel mas abajo
	ld	c,a			; ahora el BC tenemos la cords.X e Y del prota
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR a la IZQ. del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	call	COLISIONES		; leido el CHR vamos a mirar las colisiones con el fondo
	ld	a,[COLISION]		; leemos la variable COLISION
	or	a			; es 0?
	ret	nz			; NO? hemos detectamos colision y salimos de la rutina
; segundo CHR a la izquierda del prota 9 pixeles abajo
	ld	a,[coordX]		; leemos la coord.X del prota
	sub	1			; le restamos 1 para que sea el CHR a la izquierda del prota 
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	add	9			; le sumamos 9 para que sea el segundo CHR de debajo
	ld	c,a			; ahora el BC tenemos la cords.X e Y del prota
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR a la IZQ. del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	call	COLISIONES		; leido el CHR vamos a mirar las colisiones con el fondo
	ld	a,[COLISION]		; leemos la variable COLISION
	or	a			; es 0?
	ret	nz			; NO? hemos detectamos colision y salimos de la rutina
; segundo CHR a la izquierda del prota 13 pixeles abajo ( cuando esta saltando se puede dar el caso )
	ld	a,[coordX]		; leemos la coord.X del prota
	sub	1			; le restamos 1 para que sea el CHR a la izquierda del prota
	ld	b,a			; la pasamos al registro B
	ld	a,[coordY]		; leemos la coord.Y del prota
	add	12			; le sumamos 12 para que sea el segundo CHR de debajo
	ld	c,a			; ahora el BC tenemos la cords.X e Y del prota
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR a la IZQ. del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	jr	COLISIONES		; leido el CHR vamos a mirar las colisiones con el fondo
;--------------------------------------

; vamos a mirar colisiones a la DERECHA del prota comprobar los 2 CHRs en 3 posiciones por el tema de los saltos
A_LA_DER:
; primer CHR a la derecha del prota
	ld	a,[coordX]		; leemos la coord.X del prota
	add	ANCHO_PROTA		; le sumamos el ancho del prota para mirar el CHR delante del prota
	ld	b,a			; la pasamos a B
	ld	a,[coordY]		; leemos la coord.Y del prota
	cp	191-10			; si la cordenada Y es mayor de 181
	ret	nc			; salimos sin mirar colisiones
	add	1			; le sumamos 1 para ajustes hay veces que se queda un pixel mas abajo
	ld	c,a			; ahora el BC tenemos la cords.X e Y debajo del prota CHR 1
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR a la DER. del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	call	COLISIONES		; leido el CHR vamos a mirar las colisiones con el fondo
	ld	a,[COLISION]		; leemos la variable COLISION
	or	a			; es 0?
	ret	nz			; NO? hemos detectamos colision y salimos de la rutina
; segundo CHR a la derecha del prota 9 pixeles abajo
	ld	a,[coordX]		; leemos la coord.X del prota
	add	ANCHO_PROTA		; le sumamos el ancho del prota para mirar el CHR delante del prota
	ld	b,a			; la pasamos a B
	ld	a,[coordY]		; leemos la coord.Y del prota
	add	9			; le sumamos 9 para que sea el segundo CHR de debajo
	ld	c,a			; ahora el BC tenemos la cords.X e Y debajo del prota CHR 2
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR a la IZQ. del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
	call	COLISIONES		; leido el CHR vamos a mirar las colisiones con el fondo
	ld	a,[COLISION]		; leemos la variable COLISION
	or	a			; es 0?
	ret	nz			; NO? hemos detectamos colsion y salimos de la rutina
; segundo CHR a la derecha del prota 13 pixeles abajo
	ld	a,[coordX]		; leemos la coord.X del prota
	add	ANCHO_PROTA		; le sumamos el ancho del prota para mirar el CHR delante del prota
	ld	b,a			; la pasamos a B
	ld	a,[coordY]		; leemos la coord.Y del prota
	add	12			; le sumamos 12  para que sea el segundo CHR de debajo
	ld	c,a			; ahora el BC tenemos la cords.X e Y debajo del prota CHR 2
	call	LEE_CHR			; en base a las coordenadas en BC localizar el CHR a la IZQ. del prota...
					; ...que hay en bufferNAM el resultado viene en el registro A
COLISIONES:
	cp	60			; es el CHR del AURA AZUL?
	jr	z,AURA_AZUL		; SI? vamos a AURA_AZUL
	cp	61			; es el CHR del AURA_ROJA?
	jr	z,AURA_ROJA		; SI? vamos a AURA_ROJA
	cp	59			; es el CHR del CORAZON?
	jr	z,VIDA			; SI? vamos a CORAZON
	cp	47			; es el CHR de la POCION azul? 
	jp	z,POCION		; SI? vamos a POCION
	cp	62			; es el CHR del PINCHO 1?
	jp	z,@@CON_COLI		; SI? vamos a @@CON_COLI para que muera
	cp	63			; es el CHR del PINCHO 2?
	jp	z,@@CON_COLI		; SI? vamos a @@CON_COLI para que muera
	cp	44			; es el CHR del PARALIZADOR?
	jp	z,PARALIZAR		; SI? vamos a PARALIZADOR
	cp	45			; es el CHR de la LLAVE de cloaca?
	jp	z,LLAVE			; SI? vamos a LLAVE
	cp	252			; es el primer framento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS
	cp	253			; es el segundo framento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS
	cp	254			; es el tercer framento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS
	cp	255			; es el cuarto framento del MAPA?
	jp	z,MAPAS			; SI? vamos a MAPAS

; aqui comprobamos si el CHR leido enta comprendido entre 1 y 32 que son los solidos
	cp	1			; vamos a mirar solidos
	jr	nc,SOLIDOS		; es mayor de 1 vamos a mirarlos

NO_SOLIDOS:
; los CHRs no son solidos
	xor	a
	ld	[COLISION],a		; COLISION = 0 no hay colision
	ret				; salimos de la rutina

SOLIDOS:
; los CHRs son solidos
	cp	32			; vamos a mirar si son solidos
	jr	nc,NO_SOLIDOS		; si el CHR leido es mayor de 32 no es solido
	ld	a,1
	ld	[COLISION],a		; COLISION = 1 hay colision
	ret				; salimos de la rutina
;--------------------------------------

;--------------------------------------
; AQUI EMPIEZAN LOS OBJETOS DETECTADOS
;--------------------------------------
AURA_AZUL:
	ld	a,$01			; sumaremos 1 punto pero en el marcador seran 10 porque tenemos un 0
OTRA_SUMA:
	push	af			; guardamos los puntos en la pila
;--------------------------------------
; WYZ
	LD	B,SFX_MONEDA		; efecto de sonido al coger un aura
	CALL	INICIA_EFECTO		; hacer sonar el efecto
; WYZ
;--------------------------------------
	pop	af			; recuperamos los puntos de la pila
	ld	hl,PUNTOS		; nos situamos en la variable PUNTOS en formato BCD
	ld	b,2			; bytes de la variable PUNTOS ( 00 00 00 )
	add	[hl]			; sumamos 1 punto a la variable en el marcador 10 porque tenemos un 0
	daa				; ajuste decimal del acumulador ya que trabajamos en BCD
	ld	[hl],a			; una vez sumado la almacenamos en la variable PUNTOS
	inc	hl			; vamos con la segunda posicion de la variable PUNTOS

@@BUCLE_SUMABCD:
	ld	a,[hl]			; aqui relizamos la suma de la PUNTUACION
	adc	0			; teniendo en cuenta el carry con la suma
	daa				; y los 3 bytes que componen la puntuacion
	ld	[hl],a			; 
	inc	hl			;
	djnz	@@BUCLE_SUMABCD		; repetimos mientras no terminemos con los 3 bytes

; aqui situamos la suma de la PUNTUACION en el marcador en el bufferNAM
	ld	b,3			; numero de bytes 00 00 00
	ld	de,PUNTOS+2		; direccion donde esta la PUNTUACION en BCD
	ld	hl,bufferNAM+(1*32)	; direccion en bufferNAM donde ponemos la PUNTUACION
	call	BCD2TEXTO		; transformamos la PUNTUACION de BCD a ASCII

; esta parte es comun para todos los objetos se trata de borrar en objeto en la pantalla y en la tabla en RAM
COMUN:
	call	BORRA_OBJ_RAM		; borra los objetos que recogemos en RAM
	call	BORRA_OBJ_VRAM		; borra los objetos que recogemos en VRAM

	ret				; salimos de la rutina AURA_AZUL y AURA_ROJA
;--------------------------------------

AURA_ROJA:
	ld	a,$05			; sumaremos 5 puntos pero en el marcador seran 50
	jr	OTRA_SUMA		; lo mandamos a OTRA_SUMA en AURA AZUL
;--------------------------------------

VIDA:
;--------------------------------------
; WYZ
	LD	B,SFX_ITEM		; efecto de sonido al coger un corazon
	CALL	INICIA_EFECTO		; hacer sonar el efecto
; WYZ
;--------------------------------------
	ld	bc,1607h		; ponemos el borde rojo para el efecto del flash
	call	CAMBIA_BORDE		; rutina encargada de hacer un flash de color cambiando el borde

	ld	hl,VIDAS_BCD		; HL apunta a la posicion de memoria donde tenemos el numero de vidas en BCD 
	ld	b,1			; B = 1 vida a sumar
	ld	a,[hl]			; leemos el numero de vidas en BCD que tenemos
	add	a,b			; y le sumamos una vida
	daa				; ajuste decimal del acumulador ya que trabajamos en BCD
	ld	[hl],a			; una vez que hemos sumado una vida para el texto del marcador la guardamos

	ld	b,1			; numero de bytes
	ld	de,VIDAS_BCD		; direccion donde estan las vidas en BCD
	ld	hl,bufferNAM+15+(1*32)	; direccion en bufferNAM donde ponemos el numero de vidas ea el marcador
	call	BCD2TEXTO		; transformamos el numero de vidas de BCD a ASCII

	ld	a,[VIDAS]		; leemos la variable con el numero de vidas
	inc	a			; le sumamos una vida
	ld	[VIDAS],a		; y la almacenamos

; solo mostraremos el texto al coger el primer corazon
	ld	a,[NOTXT_COR]		; leemos la variable NO_TXT_COR
	or	a			; es 0?
	jr	z,COMUN			; SI? vamos a COMUN sin mostrar el mensaje

; mostrar el texto de ayuda al recoger el primer paralizador
	call	BORRA_SCR		; borra la parte de la pantalla donde ponemos el texto y quita SPRs
	ld	de,TXT_CORAZON		; direccion del texto a imprimir
	ld	hl,NAMTBL+(11*32)	; direccion de la NAMTBL en VRAM donde empieza a escribir el texto
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR
	call	REPONE_SCR		; volver a colocar la parte de la pantalla que habiamos borrado
	xor	a			; ponemos a 0 la variable NOTXT_COR
	ld	[NOTXT_COR],a		; para no mostrar el texto del corazon la proxima vez

	jr	COMUN			; borrar el objeto recogido en RAM y VRAM
;--------------------------------------

POCION: 
;--------------------------------------
; WYZ
	LD	B,SFX_ITEM		; efecto de sonido al coger la pocion
	CALL	INICIA_EFECTO		; hacer sonar el efecto
; WYZ
;--------------------------------------
	ld	bc,1407h		; ponemos el borde azul para el efecto del flash
	call	CAMBIA_BORDE		; rutina encargada de hacer un flash de color cambiando el borde

	ld	a,2			; vamos a activar la inmunidad del prota
	ld	[ACCIONES],a		; ACCIONES = 2 inmunidad
	xor	a			; ld a,0
	ld	[TIEMPO],a		; ponemos el tiempo de inmunidad a 0

; solo mostraremos el texto al coger el primer corazon
	ld	a,[NOTXT_POC]		; leemos la variable NO_TXT_POC
	or	a			; es 0?
	jr	z,COMUN			; SI? vamos a COMUN sin mostrar el mensaje

; mostrar el texto de ayuda al recoger una pocion
	call	BORRA_SCR		; borra la parte de la pantalla donde ponemos el texto y quita SPRs
	ld	de,TXT_POCION		; direccion del texto a imprimir
	ld	hl,NAMTBL+(10*32)	; direccion de la NAMTBL en VRAM donde empieza a escribir el texto
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR
	call	REPONE_SCR		; volver a colocar la parte de la pantalla que habiamos borrado
	xor	a			; ponemos a 0 la variable NOTXT_POC
	ld	[NOTXT_POC],a		; para no mostrar el texto de la pocion la proxima vez

	jr	COMUN			; borrar el objeto recogido en RAM y VRAM
;--------------------------------------

PARALIZAR:
;--------------------------------------
; WYZ
	LD	B,SFX_ITEM		; efecto de sonido al coger un paralizador
	CALL	INICIA_EFECTO		; hacer sonar el efecto
; WYZ
;--------------------------------------
	ld	bc,1207h		; ponemos el borde verde para el efecto del flash
	call	CAMBIA_BORDE		; rutina encargada de hacer un flash de color cambiando el borde

	ld	hl,PARALIZA_BCD		; HL apunta a la posicion de memoria donde tenemos el numero de paralizadores en BCD 
	ld	b,1			; B = 1 paralizador
	ld	a,[hl]			; leemos el numero de paralizadores en formato BCD que tenemos
	add	a,b			; y le sumamos un paralizador
	daa				; Ajuste decimal del acumulador ya que trabajamos en formato BCD
	ld	[hl],a			; una vez sumado un paralizador lo guardamos en formato BCD

	ld	b,1			; numero de bytes o CHRs
	ld	de,PARALIZA_BCD		; direccion donde estan los paralizadores en formato BCD
	ld	hl,MENU_OBJETOS+8+(3*32); direccion donde mostramos el numero de paralizadores en el menu de objetos
	call	BCD2TEXTO		; transformamos el numero de paralizadores de BCD a ASCII

	ld	a,[PARALIZADOR]		; leemos la variable
	inc	a			; le sumamos uno mas
	ld	[PARALIZADOR],a		; y la almacenamos

; solo mostraremos el texto al coger el primer corazon
	ld	a,[NOTXT_PAR]		; leemos la variable NO_TXT_POC
	or	a			; es 0?
	jp	z,COMUN			; SI? vamos a COMUN sin mostrar el mensaje

; mostrar el texto de ayuda al recoger el primer paralizador
	call	BORRA_SCR		; borra la parte de la pantalla donde ponemos el texto y quita SPRs
	ld	de,TXT_PARALIZADOR	; direccion del texto a imprimir
	ld	hl,NAMTBL+(9*32)	; direccion de la NAMTBL en VRAM donde empieza a escribir el texto
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR
	call	REPONE_SCR		; volver a colocar la parte de la pantalla que habiamos borrado
	xor	a			; ponemos a 0 la variable NOTXT_COR
	ld	[NOTXT_PAR],a		; para no mostrar el texto del paralizador la proxima vez

	jp	COMUN			; borrar el objeto recogido en RAM y VRAM
;--------------------------------------

LLAVE:
;--------------------------------------
; WYZ
	LD	B,SFX_ITEM		; efecto de sonido la llave
	CALL	INICIA_EFECTO		; hacer sonar el efecto

	LD	A,$06			; cadencia
	CALL	@@START_FADE_OUT	; parar la musica de mas a menos
 ; WYZ
;--------------------------------------
; hacemos una pausita para que de tiempo a bajar el sonido
	ld	b,60			; valor del bucle
llaveP:
	halt				; esperar a la interrupcion
	djnz	llaveP			; repetir hasta que B sea 0

	ld	bc,1407h		; ponemos el azul cielo para el efecto del flash
	call	CAMBIA_BORDE		; rutina encargada de hacer un flash de color cambiando el borde

	ld	a,$01			; ponemos la llave de cloaca en formato BCD a 01
	ld	[LLAVE_BCD],a		; y la almacenamos

	ld	b,1			; numero de bytes
	ld	de,LLAVE_BCD		; direccion donde estan las paralizadores en formato BCD
	ld	hl,MENU_OBJETOS+8+(5*32); direccion en Menu de Objetos donde mostramos el numero de paralizadores
	call	BCD2TEXTO		; transformamos el numero de llave de BCD a ASCII

; Descomprimir la pantalla 12  en buffer en RAM (la pantalla donde se abre la cloaca)
	ld	hl,PANTA12		; origen en ROM
	ld	de,buffer+(2*32)	; destino en RAM
	call	unpack			; rutina descompresora Pletter
	ld	hl,buffer+(2*32)	; origen en RAM - linea 2 columna 0
	ld	de,NAMTBL+(2*32)	; destino en VRAM - linea 2 columna 0
	ld	bc,32*22		; numero de bytes - 22 lineas
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

; Borrar los ATRs de los SPRs en VRAM para que no se vean en pantalla
	call	BORRA_ATRs_SPRs		; mini-rutina que borras los ATRs de los SPRs
	
; animacion de la apertura de la cloaca al recoger la llave
; mostramos la pantalla de la cloaca cerrada y una hacemos una pausa
	call	@@PAUSITA		; rutina que realiza la pausa
;--------------------------------------
; WYZ
; descomprimir la musica de la apertura de la cloaca en RAM
	ld	hl,SONG_6	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la apertura de la cloaca
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
; WYZ
;--------------------------------------

; 1 - mostramos la cloaca abierta 2 CHRs y pausa
	ld	hl,NAMTBL+25+(23*32)    ; LOCATE 23,25
	ld	a,130			; CHR 130 
	call	@@PRINT_CHR		; escribe en VRAM el CHR 130 y 131
	call	@@PAUSITA		; rutina que realiza una pausa
; 2 - mostramos la primera animacion de la tapa, 2 CHRs y hacemos una pausa
	ld	hl,NAMTBL+25+(22*32)	; LOCATE 22,25
	ld	a,56			; CHR 56
	call	@@PRINT_CHR		; escribe en VRAM el CHR 56 y 57
	call	@@PAUSITA		; rutina que realiza una pausa
; 3 - mostramos la segunda animacion de la tapa 4m CHRs y hacemos una pausa
	ld	hl,NAMTBL+25+(21*32)	; LOCATE 21,25
	ld	a,52			; CHR 52
	call	@@PRINT_CHR		; escribe en VRAM el CHR 52 y 53
	ld	hl,NAMTBL+25+(22*32)	; LOCATE 22,25
	inc	a			; sumamos uno a 53 = CHR 54
	call	@@PRINT_CHR		; escribe en VRAM el CHR 54 y 55
	call	@@PAUSITA		; rutina que realiza una pausa
; 4 - mostramos la tercera animacion de la tapa 4, CHRs y hacemos una pausa
	ld	hl,NAMTBL+25+(21*32)	; LOCATE 21,25
	ld	a,48			; CHR 48
	call	@@PRINT_CHR		; escribe en VRAM el CHR 48 y 49
	ld	hl,NAMTBL+25+(22*32)	; LOCATE 22,25
	inc	a			; sumamos uno a 49 = CHR 50
	call	@@PRINT_CHR		; escribe en VRAM el CHR 50 y 51
	call	@@PAUSITA		; rutina que realiza una pausa
; 5 - mostramos la cuarta animacion de la tapa, 4 CHRs y hacemos una pausa
	ld	hl,NAMTBL+25+(21*32)	; LOCATE 21,25
	ld	a,52			; CHR 52
	call	@@PRINT_CHR		; escribe en VRAM el CHR 52 y 53
	ld	hl,NAMTBL+25+(22*32)	; LOCATE 22,25
	inc	a			; sumamos uno a 53 = CHR 54
	call	@@PRINT_CHR		; escribe en VRAM el CHR 54 y 55
	call	@@PAUSITA		; rutina que realiza una pausa
; 6 - mostramos la quinta animacion de la tapa, 4 CHRs y hacemos una pausa
; aqui borramos los 2 CHR de arriba ya que la tapa son 2 CHR
	ld	hl,NAMTBL+25+(21*32)	; LOCATE 21,25
	xor	a			; CHR 0 porque queremos borrar
	call	WRTVRM			; 04Dh - BIOS - Write byte to VRAM
	inc	hl			; LOCATE 21,26
	call	WRTVRM			; 04Dh - BIOS - Write byte to VRAM
; mostramos la quinta animacion de la tapa, 2 CHRs, y hacemos una pausa
	ld	hl,NAMTBL+25+(22*32)	; LOCATE 22,25
	ld	a,56			; CHR 56
	call	@@PRINT_CHR		; escribe en VRAM el CHR 56 y 57
	call	@@PAUSITA		; rutina que realiza una pausa
; 7 - mostramos la entrada a la cloaca abierta sin tapa
; aqui borramos los 2 CHR de arriba de la tapa porque ya no hay tapa
	ld	hl,NAMTBL+25+(22*32)	; LOCATE 22,25
	xor	a			; CHR 0 porque queremos borrar
	call	WRTVRM			; 04Dh - BIOS - Write byte to VRAM
	inc	hl			; LOCATE 22,26
	call	WRTVRM			; 04Dh - BIOS - Write byte to VRAM
; aqui hacemos una pausa mas larga para el usuario se quede con la pantalla donde es
	ld	b,150			; 
	call	@@BUCLE_P		; llamamos a la rutina PAUSITA+2 para saltar el LD B,50

; reponer en VRAM la pantalla donde nos encontrabamos
	call	bufNAMaVRAM2		; Mini-Rutina que lleva bufferNAM a VRAM 22 lineas

	xor	a			; ld a,0
	ld	[CLOACA],a		; activamos la variable CLOACA para la apertura
;--------------------------------------
; WYZ
; descomprimir la musica del juego en la calle en RAM
	ld	hl,SONG_1	; origen
	ld	de,MUSICA	; destino
	call	unpack		; rutina descompresora pletter de rom a ram
; hacer sonar la musica del juego en la calle
	XOR	A		; * CANCION N 0
	CALL	CARGA_CANCION	; Hacer sonar la cancion.
; WYZ
;--------------------------------------
	jp	COMUN			; borrar el objeto recogido en RAM y VRAM

@@PAUSITA:
	ld	b,40			; tiempo de la pausa
@@BUCLE_P:
	halt				; espera a la interrupcion
	djnz	@@BUCLE_P		; bucle para una pausa
 	ret				; salimos de la rutina PAUSITA

;--------------------------------------
; mini-rutina para escribir en la vram 2 CHR secuenciales
@@PRINT_CHR:
; HL con la direccion en VRAM donde vamos a escribir
; A con el numero de CHR que queremos escribir
	call	WRTVRM			; 04Dh - BIOS - Write byte to VRAM
	inc	hl			; sumamos 1 a la columna
	inc	a			; sumamos 1 al numero del CHR
	call	WRTVRM			; 04Dh - BIOS - Write byte to VRAM
	ret				; salimos de la rutina PRINT_CHR
;--------------------------------------

MAPAS:
;--------------------------------------
; WYZ
	LD	B,SFX_ITEM		; efecto de sonido al coger un mapa
	CALL	INICIA_EFECTO		; hacer sonar el efecto
; WYZ
;--------------------------------------
	ld	bc,1F07h		; ponemos el borde blanco para el efecto del flash
	call	CAMBIA_BORDE		; rutina encargada de hacer un flash de color cambiando el borde

	ld	hl,MAPA_BCD		; HL apunta a la posicion de memoria donde tenemos el numero de partes del mapa en BCD 
	ld	b,1			; B=1 parte del mapa
	ld	a,[hl]			; leemos el numero actual de partes del mapa en formato BCD que tenemos
	add	a,b			; le sumamos una parte del mapa
	daa				; ajuste decimal del acumulador ya que trabajamos en formato BCD
	ld	[hl],a			; una vez sumada la guardamos

	ld	b,1			; numero de bytes
	ld	de,MAPA_BCD		; direccion donde estan las partes del mapa en formato BCD
	ld	hl,MENU_OBJETOS+8+(7*32); direccion en Menu de Objetos donde mostramos el numero de partes del mapa
	call	BCD2TEXTO		; transformamos el numero de partes del mapa de BCD a ASCII

	ld	a,[MAPA]		; leemos la variable MAPA
	inc	a			; le sumamos un parte del mapa
	ld	[MAPA],a		; y la almacenamos
	cp	4			; miramos si tenemos las 4 partes del mapa
	jr	z,FINAL_DEL_JUEGO	; SI? vamos a mostrar el final del Juego	

; mostrar el texto de ayuda al recoger el primer paralizador
	call	BORRA_SCR		; borra la parte de la pantalla donde ponemos el texto y quita SPRs
	ld	de,TXT_MAPA		; direccion del texto a imprimir
	ld	hl,NAMTBL+(9*32)	; direccion de la NAMTBL en VRAM donde empieza a escribir
	call	TEXTO_LENTO		; rutina que imprime el texto CHR a CHR
	call	REPONE_SCR		; volver a colocar la parte de la pantalla que habiamos borrado
	jp	COMUN			; borrar el objeto recogido en RAM y VRAM

FINAL_DEL_JUEGO:
;-----------------------------------------------------------
; Rutina para mostrar el Final del Juego

	.include "code_inc\Ending.asm"
;-----------------------------------------------------------


;--------------------------------------
; Rutina que cambia el color del Borde produciendo un efecto de flash
; Entrada: BC con el numero del color y el registro 7 del VDP
; Ejemplo 1F07h color blanco 
;--------------------------------------
CAMBIA_BORDE:
	call	WRTVDP			; 047h - BIOS - Write to any VDP register
	halt				; una pausita para que se vea el cambio
	halt
	ld	bc,1107h		; ponemos el borde en negro de nuevo
	call	WRTVDP			; 047h - BIOS - Write to any VDP register
	ret				; salimos de la rutina
;--------------------------------------

;--------------------------------------
; borra la zona de pantalla y los sprites donde situaremos el texto de ayuda al recoger un objeto
;--------------------------------------
BORRA_SCR:	
; Borrar los ATRs de los SPRs en VRAM para que no se vean en pantalla
	call	BORRA_ATRs_SPRs		; mini-rutina que borras los ATRs de los SPRs

; borrar la zona de la NAMTBL en VRAM donde vamos a poner el texto
	ld	hl,NAMTBL+(8*32)	; Direccin origen en VRAM - linea 8 columna 0
	ld	bc,9*32			; n de bytes a rellenar - 9 lineas
	xor	a			; a=0 - Valor a rellenar
	call	FILVRM			; 056h - BIOS  Fill block of VRAM with data byte 

	ret				; salimos de la rutina BORRA_SCR
;--------------------------------------

;--------------------------------------
; hace una pausa para que de tiempo a leer el texto de ayuda al coger un objeto
; repone la zona de la pantalla que previamente hemos borrado para poner el texto
;--------------------------------------
REPONE_SCR:
	ld	b,150			; tiempo del bucle
@@PAUSA:
	push	bc			; guardamos el tiempo del bucle en la pila
	halt				; esperar a la interrupcion
	call	ANIMA_OBJETOS		; seguimos con la animacion de los objetos en pantalla
	pop	bc			; recuperamos el tiempo del bucle de la pila
	djnz	@@PAUSA			; repetimos la pausa mientras B no sea 0

; Colocar la parte de la pantalla que previamente hemos borrado para mostrar el texto
	ld	hl,bufferNAM+(8*32)	; Direccion de origen - fila 8 columna 0
	ld	de,NAMTBL+(8*32)	; Direccion de destino - fila 8 columna 0
	ld	bc,9*32			; Numero de CHRs
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

	xor	a			; ld a,0
	ld	[VOLVER],a		; ponemos el valor a no pulsado

	ret				; salimos de la rutina REPONE_SCR
;--------------------------------------

;-------------------------------------------------------------------
; Rutina que localiza el CHR de la pantalla que tenemos en RAM
; en bufferNAM a partir de las coordenadas suministradas en BC
; devuelve el CHR que encuentra en esas coordenadas en el registro A
; Entrada:  B = Coordenada X ; C = Coordenada Y
; Salida :  A = CHR leido en las coordenadas
; Modifica: AF, HL y DE
;-------------------------------------------------------------------
LEE_CHR:
	ld	a,c			; leemos la coord.Y
	and	$f8
	srl	a			; dividido x2
	srl	a			; dividido x4
	srl	a			; dividido x8
	ld	[FILA],a		; almacenamos la FILA del CHR para otros fines
	ld	a,c			; volvemos a leer la coord.Y
	and	$f8
	ld	h,0			; H=0
	ld	l,a			; L=coord.Y
	add	hl,hl			; x 2
	add	hl,hl			; x 4
	ld	de,bufferNAM		; direccion en RAM donde tenemos la pantalla	
	add	hl,de			; SUMA1 = coord.Y * 4 + direccion del bufferNAM
	ld	a,b			; ahora leemos la Coord.X
	srl	a			; 3 veces "srl a"
	srl	a			; es igual a tomar... 
	srl	a			; ...Coord. X dividirla por 8
	ld	[COLUMNA],a		; almacenamos la COLUMNA del CHR para otros fines
	ld	c,a			; la pasamos a C
	ld	b,0			; B=0
	add	hl,bc			; sumamos la SUMA1 + la columna
	ld	a,[hl]			; metemos en A el CHR encontrado en las coordenadas
	inc	hl			; le sumamos 1 a la direccion de la coordenadas CHR a la derecha
	ld	[DIR_CHR],hl		; guardamos la direccion a la derecha del CHR del objeto leido
					; esta sera la direccion con el CHR a reponer en el fondo al recoger el objeto.
	ret				; salimos de la rutina LEE_CHR
;--------------------------------------

;-----------------------------------------------------
;   G E S T I O N A   L A S   C O L I S I O N E S 
; D E L   P R O T A   C O N   L O S   E N E M I G O S
;-----------------------------------------------------
COLISIONAN_SPRs:
	ld	ix,datosENE		; Direcion de la tabla de enemigos en RAM

	xor	a			; numero de enemigo actual a 0
BUC_COLI:
	push	af			; guardamos el numero de enemigo actual en la pila

	call	@@SE_TOCAN		; vamos a mirar si se toca el prota con el enemigo nX
	call	c,@@CON_COLI		; si hubo colision vamos a CON_COLI 

; actualizar puntero en la tabla de enemigos, y el numero de enemigo en curso
	ld	bc,VAL_ENE		; n de valores de la tabla de enemigos
	add	ix,bc			; ahora IX apunta a la tabla del siguiente enemigo

	pop	af			; recuperamos en numero actual de enemigo
	inc	a			; le sumamos 1
	cp	NUM_ENE			; hemos llegado al final del numero de enemigos por pantalla?
	ret	z			; SI? fin de mirar colisiones y salimos de la rutina COLISIONAN_SPRs
	jr	BUC_COLI		; else vamos a mirar el siguiente enemigo

; aqui venimos cuando existe colision
@@CON_COLI:
	ld	a,[ACCIONES]		; si la variable ACCIONES contiene 1=muerto o 2=inmunidad
	or	a			; es 0? 0=normal
	ret	nz			; NO? salimos de la rutina COLISIONAN_SPRs
@@SE_MATA:
;--------------------------------------
; WYZ
	LD	B,SFX_VIDA		; efecto de sonido al morir
	CALL	INICIA_EFECTO		; hacer sonar el efecto
;--------------------------------------
	ld	a,1
	ld	[ACCIONES],a		; ACCIONES = 1 Muerto
	ld	[SE_MATA],a		; SE_MATA = 1 no se mata en la caida
	ld	a,[coordY]		; leemos la coord.Y del prota
	ld	[viejaCY],a		; guardamos la coord.Y donde estaba el prota al morir
	ld	a,[MIRA_A]		; leemos en que animacion esta el prota
	ld	[viejaANI],a		; guardamos la animacion en curso del prota al morir
	xor	a			; ld a,0
	ld	[ALTURA],a		; ponemos la altura de la caida en 0

	ret				; salimos de la rutina COLISIONAN_SPRs
;------------------------------------------------

;------------------------------------------------
; SE_TOCAN
;
; Comprueba si existe colision entre el prota 
; y los datos de la tabla de los enemigos
;
; ENTRADA:  ix - apunta a la tabla de enemigos
; SALIDA:   Carry activado si existe colision
; MODIFICA: AF,DE,BC
;------------------------------------------------
@@SE_TOCAN:
; primero miramos las coordenadas X y los anchos
	ld	a,[coordX]		; leemos la coordenada x del prota
 	add	SOBRA_X			; que pixeles sobran del prota por la izquierda
	sub	4			; restamos los 4 pixeles que le sumamos para ajustar la colisiones con el fondo
; esto es para mirar si exite colision cuando esta activado el EC
;	ld	hl,[SPR+(8*4)+3]	; ATR color 1 del prota
;	bit	7,l			; Comprobamos si EC esta activo en los ATR del prota
;	jr	z,@@SIN_EC		; NO esta activo salimos de la gestion del EC
;	add	32			; le sumamos los 32 pixeles que resta el EC a la coord.X
;	ccf				; complementamos el carry para que no se dispare...
;	ret	nc			; ...si el prota esta lejos de la derecha
;@@SIN_EC:
	ld	b,a			; lo pasamos a B
	ld	c,ANCHO_PROTA		; C = ancho del prota
	ld	a,[ix+8]		; leemos la coordenada X del enemigo en la tabla
	add	[ix+12]			; que pixeles sobran del enemigo por la izquierda
	ld	e,[ix+10]		; leemos el ancho del enemigo de la tabla
	call	@@COMPRUEBA		; B = Coord.X Prota, C = ancho del prota, A = Coord.X enemigo
	ret	nc			; volvemos si no hay colision en la comprobacion de la X
; ahora vamos a mirar las cordenadas Y y los altos	
	ld	a,[coordY]		; leemos la coordenada Y del prota
	add	SOBRA_Y			; que pixeles sobran del prota por la parte de arriba
	ld	b,a			; lo pasamos a B
	ld	c,ALTO_PROTA		; C = alto del prota
	ld	a,[ix+9]		; leemos la coordenada Y del enemigo en la tabla
	add	[ix+13]			; que pixeles sobran del enemigo por arriba
	ld	e,[ix+11]		; E = alto del enemigo 

; B = coord.Y del prota, C = alto del prota, A = coord. Y del enemigo

@@COMPRUEBA:
	sub	b			; calculamos si la coord. X o Y del enemigo es menor que la coord. X o Y del prota.
	jr	nc,@@OTRO		; si el resultado anterior es menor vamos a @@OTRO
	neg				; else invertimos el resultado con numero positivo lo pasamos valor negativo
	sub	e			; comparamos ahora las coordenadas restando el ancho o alto del enemigo
	ret				; volvemos con el resultado de si hay colision o no porque el carry se habra activado
@@OTRO:
	sub	c			; comparamos ahora las coordenadas restando el ancho o alto del prota
	ret				; volvemos con el resultado de si hay colision o no porque el carry se habra activado
;------------------------------------------------

;------------------------------------------------
; EDUARDO ROBSY (BCD2TXT)!!!
; RUTINA que convierte un numero en formato BCD
; a formato Texto en ASCII para poder imprimirlo
; ENTRADAS: B  = Numero de bytes
;	    DE = direccion del ultimo byte BCD
;	    HL = direccion del buffer de texto
;-----------------------------------------------
BCD2TEXTO:
	ld	a,[de]
	dec	de
	call	BCD2CHR
	djnz	BCD2TEXTO
	ret

BCD2CHR:
	ld	c,a
	srl	a
	srl	a
	srl	a
	srl	a
	add	48
	ld	[hl],a
	inc	hl
	ld	a,c
	and	0fh
	add	48
	ld	[hl],a
	inc	hl
	ret
;------------------------------------------------

;------------------------------------------------
; rutina que actualiza el marcador del juego
; movemos de RAM a VRAM  el marcador
;------------------------------------------------
MARCADOR:
	call	ACTU_PUNTOS		; Actualiza la puntuacion del juego

	call	ACTU_MAXPUNT		; Actualiza la maxima puntuacion del juego

; LOCATE 2,1: PRINT "0000000                0100000"
	ld	hl,bufferNAM+(1*32)	; Origen = bufferNAM columna 0 linea 2
	ld	de,NAMTBL+(1*32)	; LOCATE 2,1 : Destino la NAMBTL en VRAM
	ld	bc,32			; numero de CHR que tiene el texto
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory

	ret
;------------------------------------------------

;------------------------------------------------
; actualiza la puntuacion en el bufferNAM
; a partir de la variable PUNTOS a TEXTO
;------------------------------------------------
ACTU_PUNTOS:
	ld	b,3			; numero de bytes de la variable PUNTOS 3 = 00 00 00
	ld	de,PUNTOS+2		; ultima posicion de la variable PUNTOS en formato BCD
	ld	hl,bufferNAM+(1*32)     ;  direccion en bufferNAM donde ponemos el texto de los puntos
	call	BCD2TEXTO		; convertir de BCD a TEXTO

	ret
;------------------------------------------------

;------------------------------------------------
; actualiza la maxima puntuacion si en la partida
; los puntos han superado a la maxima puntuacion
;------------------------------------------------
ACTU_MAXPUNT: 
	ld	a,[PUNTOS+2]		; leemos el ultimo byte de la puntuacion
	ld	b,a			; lo pasamos a B
	ld	a,[MAXPUNT+2]		; leemos el ultimo byte de la maxima puntuacion
	cp	b			; lo comparamos con el ultimo byte de la puntuacion
	jr	c,@@ES_MAYOR		; es mayor? vamos a @@ES_MAYOR
	jr	nz,@@NO_ES_MAYOR	; NO es 0 vamos a @@NO_ES_MAYOR
					
	ld	a,[PUNTOS+1]		; leemos el byte del medio de la puntuacion
	ld	b,a			; lo pasamos a B
	ld	a,[MAXPUNT+1]		; leemos el byte del medio de la maxima puntuacion
	cp	b			; lo comparamos con el byte del medio de la puntuacion
	jr	c,@@ES_MAYOR		; es mayor? vamos a @@ES_MAYOR
	jr	nz,@@NO_ES_MAYOR	; NO es 0 vamos a @@NO_ES_MAYOR

	ld	a,[PUNTOS+0]		; leemos el primer byte de la puntuacion
	ld	b,a			; lo pasamos a B
	ld	a,[MAXPUNT+0]		; leemos el primer byte de la maxima puntuacion
	cp	b			; lo comparamos con el primer byte de la puntuacion
	jr	c,@@ES_MAYOR		; NO es 0 vamos a @@ES_MAYOR

	jr	@@NO_ES_MAYOR		; else no vamos a @@NO_ES_MAYOR

@@ES_MAYOR:
	ld	hl,PUNTOS		; origen nuestra puntuacion
	ld	de,MAXPUNT		; destino la maxima puntuacion
	ld	bc,3			; 3 bytes
	ldir				; llevamos nuestra puntuacion a la maxima puntuacion

@@NO_ES_MAYOR:
; ponemos en bufferNAM en la posion donde tenemos la MAX.PUNT. los ASCII de la MAX.PUNT.
	ld	b,3			; numero de bytes
	ld	de,MAXPUNT+2		; direccion donde esta la MAX.PUNT. en BCD
	ld	hl,bufferNAM+25+(1*32)	; direccion en el buffer donde ponemos la MAX.PUNT.
	call	BCD2TEXTO		; transformamos la MAX.PUNT. de BCD a ASCII

	ret				; salimos de la rutina ACTU_MAXPUNT
;---------------------------------------------------------------------------

;--------------------------------------
; Rutina encargada de colocar los objetos en la pantalla en uso
; Entrada:  Variable NUM_PANTA con el numero de pantalla
; Modifica: AF,BC,HL,DE
;--------------------------------------
OBJETOS:
	ld	ix,bufferOBJ	; direccion de la tabla de objetos

	ld	a,[NUM_PANTA]	; leemos el numero de pantalla
	or	a		; es la pantalla 0?
	jr	z,@@SIN_SUMA	; SI? no realizamos ninguna suma.
	ld	b,a		; B = numero de pantalla
	ld	de,VAL_OBJ*3	; numero de bytes por pantalla
@@SUMA:
	add	ix,de		; sumamos el numero de bytes de la tabla de objetos por pantalla
	djnz	@@SUMA		; repetimos el proceso hasta llegar al numero de pantalla en uso 
@@SIN_SUMA:
	ld	b,VAL_OBJ	; numero de objetos a colocar por pantalla
@@bucle:
	push	bc		; guardamos en la pila el numero de objetos
	ld	hl,bufferNAM	; direccion del buffer en RAM de la NAMTBL
	ld	a,[ix+1]	; leemos la FILA en la tabla de objetos
	cp	0		; es 0?
	jr	z,@@NO_PONER	; SI? no hay que ponerlo en la pantalla
	ld	e,a		; pasamos la FILA del objeto al registro E
	ld	d,0		; D=0 : ahora en DE tenemos la FILA del objeto
; multiplicamos DE por 32 CHR que tiene cada FILA en la pantalla
	sla	e		
	rl	d		; x2
	sla	e
	rl	d		; x4
	sla	e
	rl	d		; x8
	sla	e
	rl	d		; x16
	sla	e
	rl	d		; x32

	ld	c,[ix+0]	; leemos la COLUMNA en la tabla de objetos y la pasamos a C
	ld	b,0		; B=0 ahora en BC tenemos la COLUMNA del objeto
; sumar a la direccion bufferNAM la columna y la fila del objeto
	add	hl,bc		; sumamos a la bufferNAM la COLUMNA 
	add	hl,de		; y a esta suma le aadimos la FILA
	ld	a,[ix+2]	; leemos el CHR de la tabla de objetos que hay que colocar en la pantalla
	ld	[hl],a		; y lo ponemos pantalla que tenemos en bufferNAM en RAM
@@NO_PONER:
	inc	ix		;
	inc	ix		;
	inc	ix		; sumamos 3 a la direccion de la tabla de objetos ya que cada objeto ocupa 3 bytes
	pop	bc		; recuperamos de la pila el numero de objetos que queda por colocar en la pantalla
	djnz	@@bucle		; restamos un objeto y repetimos hasta terminar de colocar todos los objetos en pantalla

	ret			; salimos de la rutina OBJETOS
;--------------------------------------

;--------------------------------------
; Rutina encargada de borrar los objetos en VRAM en la NAMTBL
; Se usan las variables FILA y COLUMNA donde borrar el objeto
; y se usa la variable DIR_CHR con la direccion del CHR que
; hay que reponer en la pantalla en la NAMTBL en VRAM
;--------------------------------------
BORRA_OBJ_VRAM:
	ld	hl,NAMTBL	; direccion de origen
	ld	a,[FILA]	; leemos la FILA del objeto
	ld	e,a		; la pasamos a E
	ld	d,0		; D=0 ahora en DE tenemos la FILA
; multiplicamos DE por 32 CHR que tiene cada FILA en la pantalla
	sla	e		
	rl	d		; x2
	sla	e
	rl	d		; x4
	sla	e
	rl	d		; x8
	sla	e
	rl	d		; x16
	sla	e
	rl	d		; x32

	ld	a,[COLUMNA]	; leemos la COLUMNA del objeto
	ld	c,a		; la pasamos s C
	ld	b,0		; b=0 ahora en BC tenemos la COLUMNA
; sumar a la direccion de la NAMTBL la columna y la fila del objeto
	add	hl,bc		; sumamos a la NAMTBL la COLUMNA
	add	hl,de		; y a esta suma le aadimos la FILA
	ld	de,[DIR_CHR]	; direccion en RAM donde esta el CHR del fondo a reponer
	ld	a,[de]		; A = CHR que escribiremos en VRAM
	call	WRTVRM		; 04Dh - BIOS - Write byte to VRAM

	ret			; salimos de la rutina BORRA_OBJ_VRAM
;--------------------------------------

;--------------------------------------
; Rutina encargada de borrar los objetos recogidos
; en la pantalla en uso y de la tabla de objetos en RAM
; para que la proxima vez al entrar en la pantalla no aparezcan
; Entrada:  Variable NUM_PANTA con el numero de la pantalla
;           Variables COLUMNA y FILA donde hay que borrar
; Modifica: AF,BC,HL,DE
;--------------------------------------
BORRA_OBJ_RAM:
	ld	ix,bufferOBJ	; direccion de la tabla de objetos

	ld	a,[NUM_PANTA]	; leemos el numero de pantalla
	or	a		; es la pantalla 0?
	jr	z,@@SIN_SUMA	; no relizamos ninguna suma
	ld	b,a		; la pasamos a B
	ld	de,VAL_OBJ*3	; numero de bytes pon pantalla en DE
@@SUMA:
	add	ix,de		; sumamos a la direccion de la tabla de objetos el numero de bytes por pantalla
	djnz	@@SUMA		; repetimos el proceso hasta llegar al numero de pantalla en uso
@@SIN_SUMA:
	ld	b,VAL_OBJ	; B = numero de objetos por pantalla
@@bucle:
; aqui miramos si la COLUMNA y la FILA del objeto recogido coincide con el de la tabla de objetos
	ld	a,[ix+0]	; leemos la COLUMNA en la tabla de objetos
	ld	c,a		; la pasamos a C
	ld	a,[COLUMNA]	; leemos la COLUMNA del objeto recogido
	cp	c		; comparamos si son iguales
	jr	nz,@@OTRO	; si no son iguales vamos a mirar el siguiente objeto en @@OTRO
	ld	a,[ix+1]	; leemos la FILA de la tabla de objetos
	ld	c,a		; la pasamos a C
	ld	a,[FILA]	; leemos la FILA del objeto recogido
	cp	c		; comparamos si son iguales
	call	z,@@BORRA	; SI? vamos a borrar objeto en la tabla
@@OTRO:
	inc	ix
	inc	ix
	inc	ix		; sumamos 3 a la direccion de la tabla de objetos ya que cada objeto ocupa 3 bytes 
	djnz	@@bucle		; restamos un objeto y repetimos hasta terminar de mirar todos los objetos de la pantalla
	ret			; salimos de la rutina BORRA_OBJ_VRAM

@@BORRA:
	ld	[ix+1],0	; en la FILA de la tabla de objetos colocamos un 0
	ld	de,[DIR_CHR]	; direccion en RAM donde esta el CHR del fondo
	ld	a,[de]		; A = CHR que escribiremos en bufferNAM
	dec	de		; direccion en RAM donde esta el objeto a borrar
	ld	[de],a		; colocamos el CHR leido a la derecha de este donde estaba el objeto.

	ret			; salimos de la rutina @@BORRA
;--------------------------------------

;--------------------------------------
; Rutina encargada de animar los objetos en la pantalla
; modificando el CHR en la CHRTBL y el COLOR en la CLRTBL
;--------------------------------------
ANIMA_OBJETOS:
; si estamos en el MENU HISTORIA no animamos los objetos y salimos.
	ld	a,[EN_HISTORIA]		; leemos la variable EN_HISTORIA
	or	a			; es 0?
	ret	nz			; NO? salimos de la rutina ANIMA_OBJETOS

; esto lo realizamos para que la animacion de los objetos sea mas lenta o pausada
	ld	a,[ANI_OBJ]		; leemos la variable ANI_OBJ
	inc	a			; le sumamos uno
	and	3			; si llega a 4 la ponemos a 0
	ld	[ANI_OBJ],a		; la guardamos para la proxima vez
	or	a			; si es 0 animaremos los objetos
	ret	nz			; else cada 3 veces saldremos de la rutina sin animar
	
	ld	hl,OBJETOS_CHR		; direccion de los CHRs de los objetos a animar
	ld	ix,TBL_NUM_OBJ		; direccion con la Tabla de los numero de CHR a modificar
	ld	b,6			; numero de objetos a modificar 6 objetos
					; aura azul,roja,corazon,pocion,paralizador y llave
@@bucleCHR:
	push	bc			; almacenamos en la pila el numero de objetos a modificar
	push	hl			; almacenamos en la pila la direccion de los CHRs de los OBJs
	ld	de,CHRTBL		; vamos a modificar en la CHRTBL los CHRs
	ld	a,[ix]			; leemos el numero de CHR a modificar
	call	CAMBIA_CHR		; escribe en VRAM el CHR en la CHRTBL en los 3 tercios
	pop	hl			; recuperamos de la pila la direccion de los CHRs de los OBJs 
	ld	bc,8*4			; cada CHR tiene 8 bytes por 4 animaciones
	add	hl,bc			; se lo sumamos a la direccion para que apunte al siguiente OBJ
	inc	ix			; le sumamos uno a la tabla para leer el siguiente CHRs a modificar
	pop	bc			; recuperamos de la pila el n de objetos a modificar
	djnz	@@bucleCHR		; mientras no terminemos con los 6 seguimos cambiando CHRs

	ld	hl,OBJETOS_CLR		; direccion de los CLRs de los objetos a animar
	ld	ix,TBL_NUM_OBJ		; direccion con la Tabla de los numero de CHR a modificar
	ld	b,6			; numero de objetos a modificar 6 objetos
					; aura azul,roja,corazon,pocion,paralizador y llave
@@bucleCLR:
	push	bc			; almacenamos en la pila el numero de objetos a modificar
	push	hl			; almacenamos en la pila la direccion de los CLRs de los OBJs
	ld	de,CLRTBL		; vamos a modificar en la CLRTBL los CLRs de los CHRs
	ld	a,[ix]			; leemos el numero de CHR a modificar
	call	CAMBIA_CHR		; escribe en VRAM el CHR en la CLRTBL en los 3 tercios
	pop	hl			; recuperamos de la pila la direccion de los CLRs de los OBJs 
	ld	bc,8*4			; cada CLR tiene 8 bytes por 4 animaciones
	add	hl,bc			; se lo sumamos a la direccion para que apunte al siguiente OBJ
	inc	ix			; le sumamos uno a la tabla para leer el siguiente CLRs a modificar
	pop	bc			; recuperamos de la pila el n de objetos a modificar
	djnz	@@bucleCLR		; mientras no terminemos con los 6 seguimos cambiando CLRs

FINI:
; esta variable se utiliza para controlar las 4 fases de animacion que tienen los objetos
	ld	a,[CONTADOR]		; leemos la variable CONTADOR
	inc	a			; le sumamos uno
	and	3			; si llega a 4 lo dejamos a 0
	ld	[CONTADOR],a		; y la almacenamos

	ret				; salimos de la rutina ANIMA_OBJETOS
;--------------------------------------

TBL_NUM_OBJ:
	db	60,61,59,47,44,45	; Aura azul,roja,corazon,pocion,paralizador y llave


;--------------------------------------
; Esta es la rutina encargada de escribir en VRAM el CHR o el CLR en los 3 tercios
; ENTRADAS: HL direccion de los bytes del CHRs o CLRs
;           DE direccion inicial en VRAM del CHRTBL o CLRTBL
; SALIDA;   la CHRTBL o la CLRTBL son modificados con el
;	    numero de CHR o CLR en cada uno de los tres tercios
; MODIFICA: AF,HL,DE,BC
;--------------------------------------
CAMBIA_CHR:
	push	af			; almacenamos en la pila el n de CHR a modificar
	ld	a,[CONTADOR]		; leemos la variable CONTADOR que nos dice en que animacion estamos
	sla	a			; lo multiplicamos x2
	sla	a			; lo multiplicamos x4
	sla	a			; lo multiplicamos x8 que son los bytes que tiene cada CHR
	ld	c,a			; la variable CONTADOR multiplicada por 8 la pasamos a C
	ld	b,0			; B=0 ahora en BC tenemos la multiplicacion de arriba
	add	hl,bc			; le sumamos el contador x 8 para que apunte a la siguiente animacion
	pop	af			; recuperamos de la pila el n de CHR a modificar en A
	push	hl			; guardamos en la pila la direccion de los bytes del objeto
	ld	l,a			; metemos en L el CHR a modificar
	ld	h,0			; H=0 ahora en HL tenemos el CHR a modificar
	sla	l		
	rl	h			; x2
	sla	l
	rl	h			; x4
	sla	l
	rl	h			; x8      multiplicamos por 8 bytes que tiene cada CHR
	add	hl,de			; a la direccion CHRTBL o CLRTBL le sumamos la direccion del n del CHR x 8
	ex	de,hl			; la suma la pasamos a DE
	pop	hl			; recuperamos de la pila la direccion de los bytes del CHR del objeto
	call	CAMBIA			; escribe en vram el CHR en el tercio 1 y pasa a tercio 2
	call	CAMBIA			; escribe en vram el CHR en el tercio 2 y pasa a tercio 3
	ld	bc,8			; numero de bytes 8 un CHR			
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory 
					; escribimos el CHR en el tercio 3
	ret				; salimos de la rutina CAMBIA_CHR

CAMBIA:
	push	hl			; guardamos en la pila la direccion en ROM donde leemos los bytes del objeto
	push	de			; guardamos en la pila la direccion en VRAM donde escribimos
	ld	bc,8			; numero de bytes 8 un CHR
					; escribimos el CHR XX en la VRAM
	call	LDIRVM			; 05Ch - BIOS  Copy block to VRAM, from memory
; cambio de tercio o banco
	pop	hl			; recuperamos de la pila DE con la direccion en VRAM donde escribimos en HL
	ld	de,2048			; 2048 bytes para situarnos en otro tercio o banco de CHRs o CLRs en VRAM
	add	hl,de			; a la direccion en VRAM le sumamos los 2048 bytes 
	ex	de,hl			; la suma la pasamos a HL
	pop	hl			; recuperamos de la pila la direccion en ROM donde leemos los bytes del objeto

	ret				; salimos de la rutina CAMBIA_CHR
;------------------------------------------------

;------------------------------------------------------------------------------
; TABLA DE MOVIMIENTOS DE LOS ENEMIGOS
; IX+00.- tipo		enemigo se mueve 0-horizontal 1-vertical
; IX+01.- L1		limite IZQUIERDA (si tipo 0), limite de SUBIDA (si tipo 1)
; IX+02.- L2		limite DERECHA (si tipo 0), limite de BAJADA (si tipo 1)
; IX+03.- v		Velocidad del enemigo (1,2,4 pixeles)
; IX+04.- nSPR		Numero del sprite enemigo (0,1,2...)
; IX+05.- c		Color del sprite enemigo
; IX+06.- mira a	cuando es 1, el sprite va hasta L2, cuando es 0 el sprite vuelve a L1
; IX+07.- ani	0 o 1	n de animacion que usa el enemigo
; IX+08.- x		coordenada X del enemigo
; IX+09.- y		coordenada Y del enemigo
; IX+10.- ancho		ancho del enemigo en pixeles
; IX+11,- alto		alto del enemigo en pixeles
; IX+12,- sobraX	pixeles que le sobran por la izquierda al enemigo
; IX+13,- sobraY	pixeles que le sobran por arriba al enemigo
;------------------------------------------------------------------------------
;------------------------------------------------
; G E S T I O N   D E   L O S   E N E M I G O S
; se encarga de mover a los enemigos de la pantalla
;------------------------------------------------
MOVER_ENEMIGOS:
; vamos a mirar primero si hemos usado un paralizador y no mover enemigos
	ld	a,[PARALIZA]		; leemos la variable PARALIZA
	or	a			; es 0?
	jr	z,MOVERLOS		; SI? vamos a mover los enemigos
	dec	a			; else restamos uno a la variable
	ld	[PARALIZA],a		; almacenamos el contador de tiempo paralizados
	ret				; salimos de la rutina sin mover enemigos
MOVERLOS:
	ld	a,[ENE_ANI_PASA]	; esta varible la usamos para que sea mas...
	inc	a			; ...pausado el cambio entre una animacion y otra.
	and	3			; cuando sea 4 la ponemos a 0
	ld	[ENE_ANI_PASA],a	; y la almacenamos
	
	ld	ix,datosENE		; direcion de la tabla de enemigos en RAM
;	ld	iy,bufATRsSPRs+(11*4)	; direccion de los ATRs de los SPRs en RAM "FLICKERING"
					; 8 fantasmas+3 prota=11*4 ATR por SPR
	ld	iy,bufATRsSPRs+(10*4)	; direccion de los ATRs de los SPRs en RAM
					; 8 fastasmas+2 prota=10*4 ATR por SPR
	xor	a			; numero de enemigo actual 0
@@BUCLE:
	push	af			; guardamos el numero de enemigo actual en la pila
	ld	a,[ix+0]		; el enemigo se mueve en 0-Horizontal o en 1-Vertical
	or	a			; es 0?
	jr	z,@@ENE_HORIZONTAL	; SI? el enemigo se movera en horizontal
	jr	@@ENE_VERTICAL		; else el enemigo se movera en vertical

@@ENE_HORIZONTAL:
	ld	a,[ix+6]		; el enemigo va a la 0-Izquierda o a la 1-Derecha 
	or	a			; es 0?
	jr	z,@@ENE_IZQUIERDA	; SI? el enemigo tiene que ir a la izquierda
	jr	@@ENE_DERECHA		; else el enemigo tiene que ir a la derecha

@@ENE_IZQUIERDA:
	ld	a,[ix+3]		; velocidad del enemigo 0, 1 o 2 pixeles
	ld	b,a			; lo pasamos a B
	ld	a,[ix+8]		; coordenada X del enemigo en la tabla
	sub	a,b			; como va a la izquierda restamos la velocidad...
	ld	[ix+8],a		; ...que esta en B a la coordenada X y la almacenamos
	ld	a,[ix+1]		; vamos a mirar si ha llegado al final de su movimiento a la izquierda
	ld	b,a			; lo pasamos a B
	ld	a,[ix+8]		; leemos la coordenada X del enemigo
	cp	b			; miramos si coincide con la coordenada actual del enemigo...
	jr	z,@@CAMBIA_DIR_A_DER	; SI? el enemigo tiene que cambiar para ir a la derecha
	jr	@@ENE_MOVIDO		; else enemigo ya movido

@@CAMBIA_DIR_A_DER:
	ld	a,1			; la proxima vez lo moveremos a la derecha
	ld	[ix+6],a		; lo almacenamos en la tabla del enemigo en va a la 0-Izquierda o a la 1-Derecha
	jr	@@ENE_MOVIDO		; else enemigo ya movido

@@ENE_DERECHA:
	ld	a,[ix+3]		; velocidad del enemigo 0, 1 o 2 pixeles
	ld	b,a			; lo pasamos a B
	ld	a,[ix+8]		; coordenada X del enemigo en la tabla
	add	a,b			; como va a la derecha le sumamos la velocidad...
	ld	[ix+8],a		; ...que esta en B a la coordenada X y la almacenamos

	ld	a,[ix+2]		; vamos a mirar si ha llegado al final de su movimiento a la derecha
	ld	b,a			; lo pasamos a B 
	ld	a,[ix+8]		; leemos la coordenada X del enemigo
	cp	b			; miramos si coincide con la coordenada actual del enemigo
	jr	z,@@CAMBIA_DIR_A_IZQUI	; SI? el enemigo tiene que cambiar para ir a la izquierda
	jr	@@ENE_MOVIDO		; else enemigo ya movido

@@CAMBIA_DIR_A_IZQUI:
	xor	a			; la proxima vez lo moveremos a la izquierda
	ld	[ix+6],a		; lo almacenamos en la tabla del enemigo en va a la 0-Izquierda o a la 1-Derecha
	jr	@@ENE_MOVIDO		; else enemigo ya movido

@@ENE_VERTICAL:
	ld	a,[ix+6]		; el enemigo 0-Sube o 1-Baja
	or	a			; es 0?
	jr	z,@@ENE_SUBE		; SI? el enemigo tiene que subir
	jr	@@ENE_BAJA		; else el enemigo tiene que bajar

@@ENE_SUBE:
	ld	a,[ix+3]		; velocidad del enemigo 1, 2, o 3 pixeles
	ld	b,a			; lo pasamos a B
	ld	a,[ix+9]		; coordenada Y del enemigo en la tabla		
	sub	a,b			; como esta subiendo le restamos la velocidad...
	ld	[ix+9],a		; ...que esta en B a la coordenada Y, y la almacenamos

	ld	a,[ix+1]		; vamos a mirar si ha llegado al final de su movimiento hacia arriba
	ld	b,a			; lo pasamos a B
	ld	a,[ix+9]		; leemos la cordenada Y del enemigo
	cp	b			; miramos si coincide con la coordenada actual del enemigo
	jr	z,@@CAMBIA_DIR_A_BAJAR	; SI? el enemigo tiene que cambiar para que baje
	jr	@@ENE_MOVIDO		; else enemigo ya movido

@@CAMBIA_DIR_A_BAJAR:
	ld	a,1			; la proxima vez lo moveremos hacia abajo
	ld	[ix+6],a		; lo almacenamos en la tabla del enemigo en el enemigo 0-Sube o 1-Baja
	jr	@@ENE_MOVIDO		; else enemigo ya movido

@@ENE_BAJA:
	ld	a,[ix+3]		; velocidad del enemigo 1, 2, o 3 pixeles
	ld	b,a			; lo pasamos a B
	ld	a,[ix+9]		; coordenada Y del enemigo en la tabla
	add	a,b			; como esta bajando le sumamos la velocidad...
	ld	[ix+9],a		; ...que esta en B a la coordenada Y, y la almacenamos
	
	ld	a,[ix+2]		; vamos a mirar si ha llegado al final de su movimiento hacia abajo
	ld	b,a			; lo pasamos a B
	ld	a,[ix+9]		; leemos la coordenada Y del enemigo
	cp	b			; miramos si coincide con la coordenada actual del enemigo
	jr	z,@@CAMBIA_DIR_A_SUBIR	; SI? el enemigo tiene que cambiar para que suba
	jr	@@ENE_MOVIDO		; else enemigo movido

@@CAMBIA_DIR_A_SUBIR:
	xor	a			; la proxima vez lo moveremos hacia arriba
	ld	[ix+6],a		; lo almacenamos en la tabla del enemigo en el enemigo 0-Sube o 1-Baja
	jr	@@ENE_MOVIDO		; else enemigo movido


@@ENE_MOVIDO:
; Averiguar donde empiezan los CHR del Enemigo en uso en la SPRTBL

	ld	a,POS_SPR		; numero de SPR donde empiezan los enemigos en la SPRTBL
	ld	b,a			; lo pasamos a B
; situarse en el CHR de la SPRTBL segun el numero de enemigo
	ld	a,[ix+4]		; leemos el numero de sprite enemigo
	sla	a			; lo multiplicamos por 4 ya que cada sprite
	sla	a			; de 16x16 esta compuesto de 4 CHRs
	add	a,b			; y se lo sumamos al primer numero de CHR de los enemigos
	ld	b,a			; para que apunte al numero del CHR del enemigo en uso en la SPRTBL
; situarse en el CHR del lado hacia donde mira el enemigo
	ld	a,[ix+4]		; leemos de la tabla de enemigos el numero de enemigo
	cp	7			; si es la araa como solo tiene 2 animacione en vez de 4
	jr	z,@@PASA_ENE		; saltamos esta parte para que no cambie el lado hacia donde mira
	ld	a,[ix+6]		; leemos a que direccion mira el enemigo para situarnos en ese numero de CHR
	inc	a			; le sumamos 1
	and	1			; cuando sea 2 lo dejamos a 0
	sla	a			; multiplicamos 1x1 o 0x0- 1 o 2 animacion del enemigo
	add	a,b			; se lo sumamos al numero del CHR del enemigo en uso en la SPRTBL
	ld	b,a			; lo pasamos a B
; situarse en el CHR del numero de animacion
@@PASA_ENE:
	ld	a,[ix+7]		; tabla enemigo n de animacion 0 o 1
	add	a,b			; sumamos la animacion con el lado hacia donde mira el enemigo 

	sla	a			; lo multiplicamos por 4 ya que cada sprite
	sla	a			; de 16x16 esta compuesto de 4 CHRs
					; ya tenemos calculado el numero de Sprite y el lado hacia donde mira
	ld	[iy+2],a		; almacenamos el numero de SPR en el ATR de ese enemigo en RAM

	ld	a,[ENE_ANI_PASA]	; esta variable la usamos para que sea mas...
	or	a			; ...pausado el cambio entre una animacion y otra...
	jr	z,@@CAMBIA_ANIMACION	; ...cada vez que vengamos a mover enemigos los moveremos...
	jr	@@SALTAR		; ...pero no cambiaremos la fase de animacion cada 4 pixeles.
@@CAMBIA_ANIMACION:
	ld	a,[ix+7]		; numero de animacion del enemigo 0 o 1
	inc	a			; le sumamos 1
	and	1			; cuando sea 2 la dejamos en 0
	ld	[ix+7],a		; la guardamos
@@SALTAR:
	ld	a,[ix+9]		; leemos de la tabla de enemigos la coordenada Y de ese enemigo
	ld	[iy+0],a		; actualizar la coordenada Y en el ATR de ese ememigo en RAM

	ld	a,[ix+8]		; leemos de la tabla de enemigos la coordenada X de ese enemigo
	ld	[iy+1],a		; actualizar la coordenada X en el ATR de ese enemigo en RAM

	ld	a,[ix+5]		; leemos de la tabla de enemigos el color de ese enemigo
	ld	[iy+3],a		; actualizar el color en el ATR del de ese enemigo en RAM

; actualizar punteros de la tabla de enemigos, de los atributos del sprite y del numero de enemigo en curso
	ld	bc,VAL_ENE		; n de valores de la tabla de enemigos
	add	ix,bc			; se lo sumamos y ahora IX apunta a la tabla del siguiente enemigo
	ld	bc,4			; n de valores que tienen los ATRs de un SPR
	add	iy,bc			; se lo sumamos y ahora IY apunta al siguiente ATR del SPR en RAM

	pop	af			; recuperamos en numero actual de enemigo
	inc	a			; le sumamos uno
	cp	NUM_ENE			; miramos si hemos llegado al final del numero de enemigos?
	jr	z,@@FIN_ENE		; SI? vamos a fin de mover enemigos
	jp	@@BUCLE			; else vamos a seguir moviendo el siguiente enemigo

@@FIN_ENE:
	ret				; salimos de la rutina MOVER_ENEMIGOS
;------------------------------------------------

;--------------------------------------
; Rutina encargada de escribir CHR a CHR un texto
; en la pantalla produciendo una escritura lenta
; ENTRADAS: HL con la direccion de la NAMTBL donde escribir
;           DE direccion con la cadena de texto a imprimir
; MODIFICA: AF,AF',HL,DE,BC
;--------------------------------------
TEXTO_LENTO:
	xor	a		; contador de CHRs a 0
	ex	af,af'		; AF lo pasamos AF'
@@bucle:
	ld	a,[de]		; leemos la primera letra del texto
	or	a		; es 0?
	ret	z		; SI? final del texto salimos de la rutina TEXTO_LENTO
	cp	13		; es 13?
	call	z,@@SUMA64	; SI? vamos a sumarle 2 lineas mas abajo
	push	af		; guardamos en la pila la letra leida
; vamos a mirar si hemos pulsado para que no muestre el texto CHR a CHR porque queremos salir
	ld	a,[VOLVER]	; si hemos pulsado el espacio o el boton 1 del joystick
	cp	1		; es 1?
	jr	z,@@RAPIDO	; SI? hemos pulsado y vamos a mostrar el texto de golpe
	halt			; esperamos a la interrupcion
; vamos a mirar si estamos en el el menu de la historia para realizar 2 HALT en vez de 1
	ld	a,[EN_HISTORIA]	; leemos la variable EN_HISTORIA
	or	a		; es 0?
	jr	z,@@SIN_HALT	; SI? saltamos 1 HALT al ir a @@SIN_HALT
	halt			; esperamos a la interrupcion
;	halt			; esperamos a la interrupcion
@@SIN_HALT:
; aqui guardamos los registros de esta rutina ya que vamos a otra rutina que los cambia
	push	af		; guardamos en la pila AF
	push	hl		; guardamos en la pila HL
	push	de		; guardamos en la pila DE
	push	bc		; guardamos en la pila BC
	call	ANIMA_OBJETOS	; seguimos con la animacion de los objetos en pantalla
	pop	bc		; recuperamos de la pila BC
	pop	de		; recuperamos de la pila DE
	pop	hl		; recuperamos de la pila HL
	pop	af		; recuperamos de la pila AF
@@RAPIDO:
	pop	af		; recuperamos de la pila la letra leida
	call	WRTVRM		; 04Dh - BIOS - Write byte to VRAM
	inc	de		; sumamos 1 a la direccion del texto
	inc	hl		; sumamos 1 a la direccion de la NAMTBL en VRAM
	ex	af,af'		; recuperamos el contador de CHRs
	inc	a		; le sumamos uno
	ex	af,af'		; y lo pasamos AF'
; vamos a mirar si estamos en el el menu de la historia para mirar si pulsamos botones 
	ld	a,[EN_HISTORIA]	; leemos la variable EN_HISTORIA
	cp	1		; es 1?
	call	z,MIRA_BOTONES	; SI? vamos a mirar botones

;	call	MIRA_BOTONES	; vamos a leer espacio o boton 1 del joystick 1
				; el resultado quedara en la variable VOLVER
	jr	@@bucle		; repetimos todo el proceso con la siguiente letra
@@SUMA64:
	ex	af,af'		; recuperamos el contador de CHRs
	ld	c,a		; lo pasamos a c
	ld	b,0		; b lo ponemos a 0
	sbc	hl,bc		; a la direccion de la NAMTBL en VRAM le restamos los CHRs
				; que hemos avanzado para situarnos de nuevo al principio
	ld	bc,64		; ahora le sumamos 64 CHRs a la direccion de la NAMTBL en VRAM
	add	hl,bc		; para situarnos 2 lineas mas abajo del texto
	xor	a		; ponemos a 0 de nuevo el contador de CHRs
	ex	af,af'		; y lo pasamos a AF'
	inc	de		; sumamos 1 a la direccion del texto para no imprimir el CHR 13
	ld	a,[de]		; leemos el siguiente caracter de la nueva linea

	ret			; y salimos de la rutina @@SUMA64 para seguir pintando CHRs
;------------------------------------------------

;--------------------------------------
; Rutina para cambiar el orden en la tabla
; de ATRs de los SPRs para que no desaparezca
; el 5 sprite cuando esten 5 SPRs en linea.
;--------------------------------------
;FLICKERING:
;	ld	hl,bufATRsSPRs+(11*4)	; direccion de los ATRs de los SPRs en RAM de los enemigos
;	ld	de,SPR_CLON		; direccion de los ATRs de los SPRs en RAM de los enemigos clonados
;	ld	bc,NUM_ENE*4		; 4 enemigos * 4 ATRs por enemigo 
;	ldir				; hazlo

;	ld	a,[FLICKER]		; leemos la variable FLICKER
;	inc	a			; le sumamos 1
;	and	3			; si llega a 4 la ponemos a 0
;	ld	[FLICKER],a		; y la almacenamos
;	cp	0			; es 0? 
;	jr	z,@@PUNTERO1		; SI? vamos a @@PUNTERO1
;	cp	1			; es 1?
;	jr	z,@@PUNTERO2		; SI? vamos a @@PUNTERO2
;	cp	2			; es 2?
;	jr	z,@@PUNTERO3		; SI? vamos a @@PUNTERO3
;					; else es 3
;	ld	hl,bufATRsSPRs+(14*4)	; nos situamos en la direccion del SPR14
;	ld	[PUNTERO_FLICKER],hl	; almacenamos esta direccion en la variable PUNTERO_FLICKER
;	ret				; salimos de la rutina FLICKERING
;@@PUNTERO1:
;	ld	hl,bufATRsSPRs+(11*4)	; nos situamos en la direccion del SPR11
;	ld	[PUNTERO_FLICKER],hl	; almacenamos esta direccion en la variable PUNTERO_FLICKER
;	ret				; salimos de la rutina FLICKERING
;@@PUNTERO2:
;	ld	hl,bufATRsSPRs+(12*4)	; nos situamos en la direccion del SPR12
;	ld	[PUNTERO_FLICKER],hl	; almacenamos esta direccion en la variable PUNTERO_FLICKER
;	ret				; salimos de la rutina FLICKERING
;@@PUNTERO3:
;	ld	hl,bufATRsSPRs+(13*4)	; nos situamos en la direccion del SPR13
;	ld	[PUNTERO_FLICKER],hl	; almacenamos esta direccion en la variable PUNTERO_FLICKER
;	ret				; salimos de la rutina FLICKERING
;-----------------------------------------

;------------------------------------------------
; RUTINA QUE HACE MOVER AL PROTA EN LA DEMO
; lee de una tabla las pulsaciones del teclado.
; ENTRADA: variable PUNTERO con la direccion de la tabla
MUEVE_DEMO:
	ld	hl,[PUNTERO]	; HL = direccion de la tabla almacenada en la variable PUNTERO
	ld	a,[hl]		; leemos el primer valor de la tabla
	push	af		; guardamos el valor de la tabla en la pila
	inc	hl		; le sumamos uno a la direccion de la tabla
	ld	[PUNTERO],hl	; y la almacenamos en la Variable PUNTERO
	cp	10		; es 10? el CHR leido
	jr	z,SALIDA	; SI? fin de la demo lo mandamos al principio de la ROM
	call	MIRA_BOTONES	; miramos si pulsamos botones
	ld	a,[VOLVER]	; vamos a mirar si hubo pulsacion de los botones
	cp	1		; si se pulso el valor es 1
	jr	z,SALIDA	; SI? fin de la demo lo mandamos al principio de la ROM
	pop	af		; recuperamos el valor de la tabla de la pila
	jp	ANIMAR		; NO? lo mandamos justo despues de la lectura con el dato leido de la tabla
SALIDA:
	pop	af		; sacamos de la pila el valor antes de empezar
	jp	INI_ROM		; lo mandamos al principio de la ROM
;------------------------------------------------
; tabla que contiene las pulsaciones de la demo
tblDEMO:
	incbin	"code_bin\demokeys.z80.plet5"

;------------------------------------------------
;GRABA_DEMO:
;	ld	hl,[PUNTERO]
;	ld	[hl],a
;	inc	hl
;	ld	[PUNTERO],hl
;	cp	5
;PARA:
;	jr	z,PARA
;	ret

;------------------------------------------------
; INICIALIZACION DEL PLAYER MUSICAL DE WYZ
;
INICIA_PLAYER:

; AJUSTES INICIALES
			
	CALL	PLAYER_OFF
			
; MUSICA DATOS INICIALES
	
	LD	HL,BUFFER_PLAYER	;* RESERVAR MEMORIA PARA BUFFER DE SONIDO!!!!!
	LD	DE,$0010
	LD	[CANAL_A],HL

	ADD	HL,DE
	LD	[CANAL_B],HL
	
	ADD	HL,DE
	NOP
	LD	[CANAL_C],HL 
	
	ADD	HL,DE
	LD	[CANAL_P],HL 
		
;INICIA INTERRUPCIONES
	
	LD	HL,PLAYER_INICIO
	LD	[HOOK+1],HL
	LD	A,$C3
	LD	[HOOK],A
	RET	
	
;-----------------------------------------------------------
; fichero ASM con los instrumentos y otros datos para el Player de WYZ
;-----------------------------------------------------------
Intrumentos:
	.INCLUDE "musica\mygame_intro.mus.asm"

;-----------------------------------------------------------
; fichero con la musica del pulsa para empezar comprimida con PLETTER
;-----------------------------------------------------------
SONG_0:
	.incbin  "musica\mygame_start.mus.plet5"

;-----------------------------------------------------------
; fichero con la musica del juego comprimida con PLETTER
;-----------------------------------------------------------
SONG_1:
	.incbin  "musica\mygame_ingame_2.mus.plet5"

;-----------------------------------------------------------
; fichero con la musica de las cloacas comprimida con PLETTER
;-----------------------------------------------------------
SONG_2:
	.incbin  "musica\mygame_ingame_3.mus.plet5"

;-----------------------------------------------------------
; fichero con la musica de la historia comprimida con PLETTER
;-----------------------------------------------------------
SONG_3:
	.incbin  "musica\mygame_intro.mus.plet5"

;-----------------------------------------------------------
; fichero con la musica para el final comprimida con PLETTER
;-----------------------------------------------------------
SONG_4:
	.incbin  "musica\mygame_end.mus.plet5"

;-----------------------------------------------------------
; fichero con la musica para el final comprimida con PLETTER
;-----------------------------------------------------------
SONG_5:
	.incbin  "musica\mygame_gameover.mus.plet5"

;-----------------------------------------------------------
; fichero con la musica para el final comprimida con PLETTER
;-----------------------------------------------------------
SONG_6:
	.incbin  "musica\mygame_start2.mus.plet5"

;-----------------------------------------------------------

TABLA_SONG:
	.DW	MUSICA

;WYZ
;------------------------------------------------

;---------------------------------------------------------
; Textos del Juego
;---------------------------------------------------------

TXT_PULSA:
IF (IDIOMA==1)
	db	"PULSA PARA EMPEZAR"
ELSE
	db	"PUSH TO START"
ENDIF

TXT_BLANCO:
IF (IDIOMA==1)
	db	"                  "
ELSE
	db	"             "	
ENDIF

TXT_COPYRIGHT:
	db	64," 2011 DIMENSION Z"

TXT_HISTORIA:
IF (IDIOMA==1)
	db	"HISTORIA" 
ELSE
	db	"STORY"
ENDIF

TXT_MARCADOR:
IF (IDIOMA==1)
	db	"PUNTUACION    VIDAS    MAX.PUNT."
ELSE
	db	"SCORE        LIVES      HI.SCORE"
ENDIF

TXT_PUNTOS:
IF (IDIOMA==1)
	db	"0000000        10        0100000"
ELSE
	db	"0000000        10        0100000"
ENDIF

TXT_PAUSA:
IF (IDIOMA==1)
	db	"PAUSA"
ELSE
	db	"PAUSED"
ENDIF

TXT_LISTO:
IF (IDIOMA==1)
	db	"PREPARADO:"
ELSE
	db	"READY TO GO"
ENDIF

TXT_FINJUEGO:
IF (IDIOMA==1)
	db	"FIN DE JUEGO"
ELSE
	db	"GAME OVER"
ENDIF

TXT_PARALIZADOR:
IF (IDIOMA==1)
	db	32,44," UN PARALIZADOR DE ENEMIGOS",13
	db	" USALO DONDE QUIERAS PULSANDO EL",13
	db	" ESPACIO O EL BOTON DEL JOYSTICK",13
	db	" PULSA TECLA F1 PARA VER EL MENU",0
ELSE
	db	32,44," IT WILL FREEZE THE ENEMIES",13
	db	" WHEN YOU WANT TO USE IT",13
	db	" PRESS SPACE OR JOYSTICK BUTTON.",13
	db	" PRESS F1 KEY TO VIEW THE MENU.",0
ENDIF
TXT_POCION:
IF (IDIOMA==1)
	db	32,47," ESTA POCION TE DARA UNOS",13
	db	" SEGUNDOS DE INMUNIDAD.",13
	db	" DESDE ESTE MISMO INSTANTE.",0
ELSE
	db	32,47," THIS POTION WILL GIVE YOU",13
	db	" A FEW SECONDS OF INMUNITY.",13
	db	" FROM THIS MOMENT.",0
ENDIF

TXT_CORAZON:
IF (IDIOMA==1)
	db	32,59," ENHORABUENA ESTE CORAZON TE",13
	db	" TE HA A",95,"ADIDO UNA VIDA MAS.",0	; CHR 95 = 
ELSE
	db	32,59," CONGRATULATIONS THIS HEART",13
	db	"HAS ADDED ONE LIVE TO YOUR SCORE",0
ENDIF

TXT_MAPA:
IF (IDIOMA==1)
	db	" ENHORABUENA HAS ENCONTRADO",13
	db	" UN FRAGMENTO DEL MAPA.",13
	db	" SIGUE BUSCANDO LOS OTROS.",13
	db	" PULSA TECLA F1 PARA VER EL MENU",0
ELSE
	db	" CONGRATULATIONS YOU HAVE FOUND",13
	db	" A MAPS FRAGMENT.",13
	db	" STILL LOOKING FOR OTHERS.",13
	db	" PRESS F1 KEY TO VIEW THE MENU.",0
ENDIF

TXT_CLOACA:
IF (IDIOMA==1)
	db	"BAJAS A LAS CLOACAS DE LA CIUDAD",13
	db	"TENDRAS QUE SOPORTAR EL MAL OLOR",13
	db	"LO IMPORTANTE ES LA BUSQUEDA...",0
ELSE
	db	" DOWN IN THE SEWERS OF THE CITY",13
	db	" YOU HAVE TO ENDURE THE SMELL.",13
	db	" SEARCHING IS MORE IMPORTANT...",0
ENDIF

TXT_CALLE:
IF (IDIOMA==1)
	db	" POR FIN SALGO DE LAS CLOACAS",13
	db	" YA NO AGUANTABA EL MAL OLOR",13
	db	" SIGAMOS CON LA BUSQUEDA...",0
ELSE
	db	" FINALY OUT OF THE SEWERS",13
	db	" THIS ODOR IS UNBEARABLE.",13
	db	" CONTINUE YOUR QUEST...",0
ENDIF

TXT_SCORE:
IF (IDIOMA==1)
	db	"TU PUNTUACION"
ELSE
	db	"YOUR SCORE"
ENDIF

TXT_FIN:
IF (IDIOMA==1)
	db	"FIN"
ELSE
	db	"THE END"
ENDIF

; FIN DE LOS TEXTOS DEL JUEGO
;--------------------------------------

; Tabla de la Parabola del salto del protagonista
TBL_SALTO:
	db 2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,0,0,0
	db -0,-0,-0,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2

;	tiempo=0
;	rept 50
;		db int(50.0*(sin(tiempo*1.0*pi/50)-sin((tiempo+1)*1.0*pi/50)))
;		tiempo=tiempo+1
;	endr

; ATRs de los SPRs fantasmas vacios que usaremos para nuestro beneficio usando
; la 5 regla a favor nuestro para que no pase por encima de los marcadores
TBL_VACIOS:
;         Coord.Y, Coord.X, Numero de SPR, Color
	db     -1,      0,        0,         0
	db     -1,      0,        0,         0
	db     -1,      0,        0,         0
	db     -1,      0,        0,         0

; Esto otros 4 fantamas los utilizamos para cuando baja a las cloacas
; y los desactivaremos cuando no estemos en la planta de la calle
;         Coord.Y, Coord.X, Numero de SPR, Color
	db  191-7,     0,        0,          0
	db  191-7,     0,        0,          0
	db  191-7,     0,        0,          0
	db  191-7,     0,        0,          0

;-----------------------------------------------------------
; tabla que contiene las direcciones de memoria de cada pantalla
tblPANTAS:
	dw PANTA00,PANTA01,PANTA02,PANTA03,PANTA04,PANTA05,PANTA06,PANTA07,PANTA08,PANTA09
	dw PANTA10,PANTA11,PANTA12,PANTA13,PANTA14,PANTA15,PANTA16,PANTA17,PANTA18,PANTA19
	dw PANTA20,PANTA21,PANTA22,PANTA23,PANTA24,PANTA25,PANTA26,PANTA27,PANTA28,PANTA29
	dw PANTA30,PANTA31,PANTA32,PANTA33,PANTA34,PANTA35,PANTA36,PANTA37,PANTA38,PANTA39

;-----------------------------------------------------------


;-----------------------------------------------------------
; tabla que contiene los objetos de cada pantalla del juego
; comprimido con pletter
tblOBJETOS:
	.incbin "code_bin\monedas.z80.plet5"
;-----------------------------------------------------------

;-----------------------------------------------------------
; Pletter v0.5c ROM/RAM Depacker v1.0
; asMSX adapted by Pepe Vila
; HL = RAM/ROM source compressed data 
; DE = RAM/ROM destination uncompressed data
; changes all registers
	.include "code_inc\unpack.asm"
;-----------------------------------------------------------
; CHRs de Mi logo
; CHRs del set de letras en Mayusculas
; CHRs del logotipo del Juego
; 1 banco de 256 CHRs comprimido con PLETTER
CHRs_MENUS:
	.incbin	"gfx_bin\tiles_menus.til.plet5"
;-----------------------------------------------------------
; CLRs de Mi logo
; CLRs del set de letras en Mayusculas
; CLRs del logotipo del Juego
; 1 banco de 256 CLRs comprimido con PLETTER
CLRs_MENUS:
	.incbin	"gfx_bin\tiles_menus.col.plet5"
;-----------------------------------------------------------
; NAMTBL de Mi Logotipo comprimido con PLETTER
NAM_MI_LOGO:
	.incbin	"gfx_bin\LOGO_DMZ.nam.plet5"
;-----------------------------------------------------------
; NAMTBL del Menu Game comprimido con PLETTER
NAM_MENU_GAME:
IF (IDIOMA==1)
	.incbin "gfx_bin\M_GAMEe.nam.plet5"
ELSE
	.incbin "gfx_bin\M_GAMEi.nam.plet5"
ENDIF
;-----------------------------------------------------------
; NAMTBL del Menu Creditos comprimido con PLETTER
NAM_MENU_CREDITOS:
IF (IDIOMA==1)
	.incbin "gfx_bin\M_CREDITe.nam.plet5"
ELSE
	.incbin "gfx_bin\M_CREDITi.nam.plet5"
ENDIF
;-----------------------------------------------------------
; NAMTBL del Menu Objetos comprimido con PLETTER
NAM_MENU_OBJETOS:
IF (IDIOMA==1)
	.incbin	"gfx_bin\M_OBJETOSe.z80.plet5"
ELSE
	.incbin	"gfx_bin\M_OBJETOSi.z80.plet5"
ENDIF
;-----------------------------------------------------------

;-----------------------------------------------------------
; Fichero con los textos de la HISTORIA comprimido con PLETTER
;-----------------------------------------------------------
TXTs_HISTORIA:
IF (IDIOMA==1)
	.incbin	"code_bin\txtHISTORIAe.z80.plet5"
ELSE
	.incbin	"code_bin\txtHISTORIAi.z80.plet5"
ENDIF
;-----------------------------------------------------------

;-----------------------------------------------------------
; CHRs del Juego
; TILES del primer banco
; 1 banco de 256 CHRs comprimido con PLETTER
CHRs_GAME1:
	.incbin	"gfx_bin\tiles_game1.til.plet5"
;-----------------------------------------------------------
; CLRs del Juego
; Colores de los TILES del primer banco
; 1 banco de 256 CLRs comprimido con PLETTER
CLRs_GAME1:
	.incbin	"gfx_bin\tiles_game1.col.plet5"
;-----------------------------------------------------------
; CHRs del Juego
; TILES del primer banco
; 3 banco de 256 CHRs comprimido con PLETTER
CHRs_GAME3:
	.incbin	"gfx_bin\tiles_game3.til.plet5"
;-----------------------------------------------------------
; CLRs del Juego
; Colores de los TILES del primer banco
; 3 banco de 256 CLRs comprimido con PLETTER
CLRs_GAME3:
	.incbin	"gfx_bin\tiles_game3.col.plet5"
;-----------------------------------------------------------
; Graficos del los sprites del prota.
GFX_SPR_PROTA:
	.incbin "code_bin\SPRs_prota.z80.plet5"
;-----------------------------------------------------------
; Graficos de los Sprites de los Enemigos
GFX_SPR_ENE:
	.incbin "code_bin\SPRs_enemigos.z80.plet5"
;-----------------------------------------------------------

;-----------------------------------------------------------
; Fichero con todas las pantallas del juego
; cada pantalla esta compuesta por los datos para la NAMTBL
; y la tabla de enemigos de cada pantalla
	.include "pantallas\pantallas.asm"
;-----------------------------------------------------------

;-----------------------------------------------------------
; CHRs y CLRs de los Objetos animados
OBJETOS_CHRc:
	.incbin	"gfx_bin\tiles_obj_anima.til.plet5"
OBJETOS_CLRc:
	.incbin	"gfx_bin\tiles_obj_anima.col.plet5"
;-----------------------------------------------------------

;-----------------------------------------------------------
; Player Musical de
; Jose Vicente Maso ( WYZ )
; MSX PSG proPLAYER V 0.2 - WYZ 07.09.2011
	.include "code_inc\WYZProplay47aMSX.asm"
	.include "code_inc\sfx.asm"
;-----------------------------------------------------------


;------------------------------------------------------------------------------
; FINAL DE NUESTRO CODIGO EN ROM
;------------------------------------------------------------------------------
FIN_ROM:


; ******************************************************************************
; *  V A R I A B L E S   E N   R A M  *
; ******************************************************************************
INI_RAM:
;	.org $E000		; origen para 8KB
	.page 3			; direccion C000h

;**************************************
; espacio en RAM para la descompresion.
;**************************************
; buffer para descomprimir los CHRs o CLRs
bufferCHR:
	ds	2048		; buffer de CHRs y CLRs en RAM

bufferNAM:
	ds	768		; buffer de la NAMTBL en RAM

datosENE:
	ds	VAL_ENE*NUM_ENE	; bytes de la tabla de enemigos * numero de enemigos 

buffer:
	ds	768		; buffer 2 de la NAMTBL en RAM para otros propositos
	ds	VAL_ENE*NUM_ENE	; bytes de la tabla de enemigos * numero de enemigos

;**************************************
; Variables para los menus
VOLVER:		ds	1	; se usa para saber si hemos vuelto de un menu 
PULSADO:	ds	1	; se usa para saber si hemos pulsado en los menus
CONTADOR:	ds	1	; se usa para contar x numeros de veces algo


;**************************************
; buffer para los objetos del juego
; multiplicamos los valores de los...
; ...objetos por el numero de pantallas.
; cada objeto=3 CoordY,CoordX,nde tile
bufferOBJ:	
	ds (VAL_OBJ*3)*PANTAS

;**************************************
; buffer de los ATRs de los SPRs
; Se usa para almacenar los ATRs de SPRs
; que despues moveremos a VRAM
bufATRsSPRs:
SPR:
	ds	(8+3+NUM_ENE)*4	; 8 fantasmas + 3 PROTA + 4 enemigos * 4 ATR	

; copia de los ATRs de los enemigos para la rutina de Flickering
;SPR_CLON:
;	ds	(NUM_ENE*4)	; buffer para la copia de los ATRs de los enemigos
				; para la rutina de FLICKERING

;**************************************
; buffer donde guardamos el menu
; de los objetos del juego
MENU_OBJETOS:
	ds	10*32		; buffer para el menu de objetos

;**************************************
; Variable PAUSA
; se usa para saber si se ha pulsado la
; tecla pausa durante el juego
PAUSA:
	ds	1

;**************************************
; Variable ESTADO
; Se usa para saber el estado del prota
; cuando salta o cae
; 0 = sin caida
; 1 = caida
; 2 = saltando
ESTADO:
	ds	1

;**************************************
; Variable MIRA_A
; Se usa para saber el numero de...
; ...sprite que esta usando el prota
; izquierda,derecha,escaleras,muerto etc.
MIRA_A:
	ds	1

;**************************************
; Variable viejaANI
; Se usa para almacenar en que numero
; de animacion estaba el prota
viejaANI:
	ds	1

;**************************************
; Variable ANDA
; Se usa para saber si el protagonista
; esta andando y hacia que lado lo hace.
; -1 = anda la izquierda
;  0 = no anda
;  1 = anda a la derecha
;  2 = esta en escalera
ANDA:
	ds	1

;**************************************
; Variable SALTO
; Se usa para saber en que posicion
; de la parabola se encuentra el salto
; 0 = esta al inicio del salto
SALTO:
	ds	1

;**************************************
; Variable coordX
; Se usa para saber en que coordenada X
; se encuentra el protagonista
coordX:
	ds	1

;**************************************
; Variable coordY
; Se usa para saber en que coordenada Y
; se encuentra el protagonista
coordY:
	ds	1

;**************************************
; Variable viejaCY
; Se usa para almacenar la coordenada Y
; donde estaba el prota para despues recuperarla
viejaCY:
	ds	1

;**************************************
; Variable CURoJOY
; Se usa para saber que toca leer
; 0 = Cursores  -  1 = Joystick 1
CURoJOY:
	ds	1

;**************************************
; Variable LEIDO
; Se usa para saber si no se ha dejado
; de pulsar las teclas o el boton
; almacena la lectura de CUR o JOY
LEIDO:
	ds	1

;**************************************
; Variable SALTO_OK
; Se usa para saber si se ha saltado
; y no dejar saltar hasta soltar boton
SALTO_OK:
	ds	1

;**************************************
; Variable ALTURA
; Se usa para saber desde que altura
; caera el protagonista para materse
ALTURA:
	ds	1

;**************************************
; Variable TIEMPO
; Se usa para saber cuanto tiempo
; estara el protagonista con inmunidad
TIEMPO:
	ds	1

;**************************************
; Variable ACCIONES
; Se usa para saber en que estado se
; encuentra el protagonista
; 0 - Sin Accion
; 1 - Muerto
; 2 - Inmunidad
ACCIONES:
	ds	1

;**************************************
; Variable ENE_ANI_PROTA
; Se usa para saltar animaciones asi los
; enemigos tienen una velocidad mas pausada
ENE_ANI_PASA:
	ds	1

;**************************************
; Variable NUM_PANTA
; Se usa para saber en que numero de
; pantalla estamos jugando
NUM_PANTA:
	ds	1

;**************************************
; Variable VIDAS y VIDAS_BCD
; Se usa para saber cuantas vidas le
; quedan al protagonista
; formato numero y en BCD
VIDAS:
	ds	1
VIDAS_BCD:
	ds	1

;**************************************
; Variable PUNTOS
; Se usa para almacenar la puntuacion
; del juego en formaton BCD
PUNTOS:
	ds	3

;**************************************
; Variable MAXPUNT
; Se usa para almacenar la puntuacion
; maxima del juego en formaton BCD
MAXPUNT:
	ds	3

;**************************************
; Variable BOLEANA
; 0 o 1 se usa para varios cometidos
BOLEANA:
	ds	1

;**************************************
; Variable DIR_CHR
; contiene la direccion en el bufferNAM
; del CHR que hay que reponer como fondo
; cuando recogemos un objeto
DIR_CHR:
	ds	2

;**************************************
; Variable COLISION
; contiene el TILE leido en las coords.
; para comprobar la colision con el fondo
COLISION:
	ds	1

;**************************************
; Variable FILA
; contiene la FILA de la pantalla
; del CHR leido para una accion
FILA:
	ds	1

;**************************************
; contiene la COLUMNA de la pantalla
; del CHR leido para una accion
COLUMNA:
	ds	1

;**************************************
; Variable SE_MATA
; se usa para saber si el prota ha
; superado los 80 pixeles de caida
; 0 - Se mata en la caida
; 1 - No se mata en la caida 
SE_MATA:
	ds	1

;**************************************
; Variable ANI_OBJ
; se usa para pausar la animacion de
; los objetos del juego
ANI_OBJ:
	ds	1

;**************************************
; Variable PARALIZADOR
; se usa para saber si el prota tiene
; paralizadores de enemigos
PARALIZADOR:
	ds	1

;**************************************
; Variable PARALIZA_BCD
; se usa para mostrar en el menu de
; objetos el numero de PARALIZADORES
PARALIZA_BCD:
	ds	1

;**************************************
; Variable PARALIZA
; se usa para saber si la rutina de
; movimientos de enemigos debe parar
PARALIZA:
	ds	1

;**************************************
; Variable LLAVE_BCD
; se usa para mostrar en el menu de
; objetos el numero de llave de cloacas
LLAVE_BCD:
	ds	1

;**************************************
; Variable CLOACA
; se usa para saber si hay que abrir
; la cloaca porque el prota ha cogido la llave
CLOACA:
	ds	1

;**************************************
; Variable MAPA
; se usa para saber cuantas parte del
; mapa tenemos.
MAPA:
	ds	1

;**************************************
; Variable MAPA_BCD
; se usa para mostrar en el menu de
; objetos el numero de partes del mapa
MAPA_BCD:
	ds	1

;**************************************
; Variable NO_TXT_Objeto
; se usa para saber cuando mostrar la primera
; vez el texto de ayuda al recoger un objeto.
NOTXT_POC:
	ds	1
NOTXT_COR:
	ds	1
NOTXT_PAR:
	ds	1

;**************************************
; Variable EN_HISTORIA
; se usa para saber que no hay que
; animar los objetos en el Menu Historia
EN_HISTORIA:
	ds	1

;**************************************
; Variable FLICKER
; se usa para saber en que puntero nos
; encontramos en la rutina de FLICKERING
;FLICKER:
;	ds	1

;**************************************
; Variable PUNTERO_FLICKER
; se usa para almacenar la direccion de
; memoria donde tomara los ATRs de los SPRs
;PUNTERO_FLICKER:
;	ds	2

;**************************************
; Variable QUESUENA
; se usa para saber que cancion esta sonando
QUESUENA:	ds	1

;**************************************
; Variables DEMO
; se usa para saber que estamos en demo
; 0 = MODO DEMO
; 1 = MODO NORMAL
DEMO:		ds	1

;**************************************
; Variables PUNTERO
; se usa para almacenar la direccion
; de memoria donde se leen las teclas
; de la tabla del Modo DEMO
PUNTERO:	ds	2


;------------------------------------------------------------------------------
; WYZ ESPACIO Y VARIABLES

;**************************************
; ESPACIO PARA DESCOMPRIMIDAS LAS MUSICAS EN RAM
; defino como tamao los bytes del fichero mas grande
MUSICA:
	ds	3085


;**************************************
; VARIABLES DEL PLAYER MUSICAL DE WYZ
INTERR:		ds	1		; INTERRUPTORES 1=ON 0=OFF 
					; BIT 0=CARGA CANCION ON/OFF
					; BIT 1=PLAYER ON/OFF
					; BIT 2=EFECTOS ON/OFF

; CONTROL DE LAS INTERRUPCIONES

; HOOK            EQU     $FD9F

; MUSICA **** EL ORDEN DE LAS VARIABLES ES FIJO ******

SONG:		ds	1	; DB N DE CANCION
TEMPO:		ds	1	; DB TEMPO
TTEMPO:		ds	1	; DB CONTADOR TEMPO
PUNTERO_A:	ds	2	; DW PUNTERO DEL CANAL A
PUNTERO_B:	ds	2	; DW PUNTERO DEL CANAL B
PUNTERO_C:	ds	2	; DW PUNTERO DEL CANAL C

CANAL_A:	ds	2	; DW DIRECION DE INICIO DE LA MUSICA A
CANAL_B:	ds	2	; DW DIRECION DE INICIO DE LA MUSICA B
CANAL_C:	ds	2	; DW DIRECION DE INICIO DE LA MUSICA C

PUNTERO_P_A:	ds	2	; DW PUNTERO PAUTA CANAL A
PUNTERO_P_B:	ds	2	; DW PUNTERO PAUTA CANAL B
PUNTERO_P_C:	ds	2	; DW PUNTERO PAUTA CANAL C

PUNTERO_P_A0:	ds	2	; DW INI PUNTERO PAUTA CANAL A
PUNTERO_P_B0:	ds	2	; DW INI PUNTERO PAUTA CANAL B
PUNTERO_P_C0:	ds	2	; DW INI PUNTERO PAUTA CANAL C

PUNTERO_P_DECA:	ds	2	; DW PUNTERO DE INICIO DEL DECODER CANAL A
PUNTERO_P_DECB:	ds	2	; DW PUNTERO DE INICIO DEL DECODER CANAL B
PUNTERO_P_DECC:	ds	2	; DW PUNTERO DE INICIO DEL DECODER CANAL C

PUNTERO_DECA:	ds	2	; DW PUNTERO DECODER CANAL A
PUNTERO_DECB:	ds	2	; DW PUNTERO DECODER CANAL B
PUNTERO_DECC:	ds	2	; DW PUNTERO DECODER CANAL C       

REG_NOTA_A:	ds	1	; DB REGISTRO DE LA NOTA EN EL CANAL A
		ds	1	; VACIO
REG_NOTA_B:	ds	1	; DB REGISTRO DE LA NOTA EN EL CANAL B
		ds	1	; VACIO
REG_NOTA_C:	ds	1	; DB REGISTRO DE LA NOTA EN EL CANAL C
		ds	1	; VACIO


;CANAL DE EFECTOS - ENMASCARA OTRO CANAL

PUNTERO_P:	ds	2	; DW PUNTERO DEL CANAL EFECTOS
CANAL_P:	ds	2	; DW DIRECION DE INICIO DE LOS EFECTOS
PUNTERO_P_DECP:	ds	2	; DW PUNTERO DE INICIO DEL DECODER CANAL P
PUNTERO_DECP:	ds	2	; DW PUNTERO DECODER CANAL P

;EFECTOS DE SONIDO

N_SONIDO:	ds	1	; DB : NUMERO DE SONIDO
PUNTERO_SONIDO: ds	2	; DW : PUNTERO DEL SONIDO QUE SE REPRODUC


;DB [13] BUFFERs DE REGISTROS DEL PSG

PSG_REG:	ds	$10
PSG_REG_SEC:	ds	$10
ENVOLVENTE:	ds	$10		; DB : FORMA DE LA ENVOLVENTE
					; BIT 0	  : FRECUENCIA CANAL ON/OFF
					; BIT 1-2  : RATIO 
					; BIT 3-3  : FORMA	

FADE:		ds	1		; BIT 0 FADE OUT ON/OFF
					; BIT 1 FADE IN  ON/OFF
FADE_METER:	ds	1		; DB FADE_METER (TIEMPO DE ACTUACION)
DECAY:		ds	1		; DB CADENCIA>1
DECAY_TEMP:	ds	1		; DB

;______________________________________________________

;**************************************
;VARIABLES EFECTOS DE SONIDO

N_EFECTO:	ds	1	; DB : NUMERO DE SONIDO
PUNTERO_EFECTO:	ds	2	; DW : PUNTERO DEL SONIDO QUE SE REPRODUCE;REPRODUCE EFECTOS
CANAL_EFECTOS:	ds	1	; DB : 1:CANAL A - 2:CANAL B - OTRO:CANAL C


;**************************************
; buffer para el PLAYER de WYZ
BUFFER_PLAYER:
	ds	$40		; buffer del player de WYZ

; WYZ
;------------------------------------------------------------------------------

;**************************************
; Buffer para descomprimir los textos de la historia del juego
; reservamos el numero de bytes que ocupa cada parrafo
	TXT_CUENTO:
IF (IDIOMA==1)
		ds	309
ELSE
		ds	278
ENDIF

	TXT_CUENTO1:
IF (IDIOMA==1)
		ds	304
ELSE
		ds	282
ENDIF

;**************************************
; Buffer para descomprimir los textos del Final del juego
; reservamos el numero de bytes que ocupa cada parrafo
	TXT_FINAL0:
IF (IDIOMA==1)
		ds	238
ELSE
		ds	236
ENDIF

	TXT_FINAL1:
IF (IDIOMA==1)
		ds	253
ELSE
		ds	233
ENDIF

	TXT_FINAL2:
IF (IDIOMA==1)
		ds	261
ELSE
		ds	244
ENDIF

	TXT_FINAL3:
IF (IDIOMA==1)
		ds	125
ELSE
		ds	125
ENDIF

	TXT_FINAL4:
IF (IDIOMA==1)
		ds	124
ELSE
		ds	119
ENDIF

	TXT_FINAL5:
IF (IDIOMA==1)
		ds	131
ELSE
		ds	116
ENDIF

	TXT_FINAL6:
IF (IDIOMA==1)
		ds	129
ELSE
		ds	114
ENDIF

	TXT_FINAL7:
IF (IDIOMA==1)
		ds	120
ELSE
		ds	118
ENDIF

;**************************************
; Buffer para descomprimir los OBJETOS animados
; aura azul y roja,corazon,pocion,paralizador y llave
OBJETOS_CHR:
	ds	(6*8)*4	; 6 CHRs * 8 Bytes * 4 animaciones
OBJETOS_CLR:
	ds	(6*8)*4	; 6 CLRs * 8 bytes * 4 animaciones


;**************************************
FIN_RAM:
;**************************************



;*********************************************
; CREAR EL .TXT CON LA INFORMACION ADICIONAL
;*********************************************
.printtext	"JumpinG (The Tutorial Game)"
.printtext	" "

.print		FIN_ROM-4000h
.printtext      "bytes ocupados en ROM (incluida la cabecera)"
.printtext	" "
.print		(1024*32)-(FIN_ROM-4000h)
.printtext      "bytes libres en ROM"
.printtext	" "

.print		FIN_RAM-$C000
.printtext      "bytes ocupados en RAM"
.printtext	" "
.print		(1024*16)-(FIN_RAM-$C000)
.printtext      "bytes libres en RAM"
.printtext	" "

;------------------------------------------------------------------------------
; FINAL DE NUESTRO CODIGO EN ENSAMBLADOR.
;------------------------------------------------------------------------------
